package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.gamelift.model.primitives.{
  PlayerData,
  NonZeroAndMaxString,
  ArnStringModel
}
import scala.jdk.CollectionConverters._
final case class CreatePlayerSessionRequest(
    gameSessionId: ArnStringModel,
    playerId: NonZeroAndMaxString,
    playerData: Option[PlayerData] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.CreatePlayerSessionRequest = {
    import CreatePlayerSessionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.CreatePlayerSessionRequest
      .builder()
      .gameSessionId(ArnStringModel.unwrap(gameSessionId): java.lang.String)
      .playerId(NonZeroAndMaxString.unwrap(playerId): java.lang.String)
      .optionallyWith(
        playerData.map(value => PlayerData.unwrap(value): java.lang.String)
      )(_.playerData)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.CreatePlayerSessionRequest.ReadOnly =
    zio.aws.gamelift.model.CreatePlayerSessionRequest.wrap(buildAwsValue())
}
object CreatePlayerSessionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.CreatePlayerSessionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.CreatePlayerSessionRequest =
      zio.aws.gamelift.model.CreatePlayerSessionRequest(
        gameSessionId,
        playerId,
        playerData.map(value => value)
      )
    def gameSessionId: ArnStringModel
    def playerId: NonZeroAndMaxString
    def playerData: Option[PlayerData]
    def getGameSessionId: ZIO[Any, Nothing, ArnStringModel] =
      ZIO.succeed(gameSessionId)
    def getPlayerId: ZIO[Any, Nothing, NonZeroAndMaxString] =
      ZIO.succeed(playerId)
    def getPlayerData: ZIO[Any, AwsError, PlayerData] =
      AwsError.unwrapOptionField("playerData", playerData)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.CreatePlayerSessionRequest
  ) extends zio.aws.gamelift.model.CreatePlayerSessionRequest.ReadOnly {
    override val gameSessionId: ArnStringModel =
      zio.aws.gamelift.model.primitives.ArnStringModel(impl.gameSessionId())
    override val playerId: NonZeroAndMaxString =
      zio.aws.gamelift.model.primitives.NonZeroAndMaxString(impl.playerId())
    override val playerData: Option[PlayerData] = scala
      .Option(impl.playerData())
      .map(value => zio.aws.gamelift.model.primitives.PlayerData(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.CreatePlayerSessionRequest
  ): zio.aws.gamelift.model.CreatePlayerSessionRequest.ReadOnly = new Wrapper(
    impl
  )
}
