package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.gamelift.model.primitives.{
  PlayerData,
  NonZeroAndMaxString,
  ArnStringModel
}
import scala.jdk.CollectionConverters._
final case class CreatePlayerSessionsRequest(
    gameSessionId: ArnStringModel,
    playerIds: Iterable[NonZeroAndMaxString],
    playerDataMap: Option[Map[NonZeroAndMaxString, PlayerData]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.CreatePlayerSessionsRequest = {
    import CreatePlayerSessionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.CreatePlayerSessionsRequest
      .builder()
      .gameSessionId(ArnStringModel.unwrap(gameSessionId): java.lang.String)
      .playerIds(playerIds.map { item =>
        NonZeroAndMaxString.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        playerDataMap.map(value =>
          value
            .map({ case (key, value) =>
              (NonZeroAndMaxString.unwrap(key): java.lang.String) -> (PlayerData
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.playerDataMap)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.CreatePlayerSessionsRequest.ReadOnly =
    zio.aws.gamelift.model.CreatePlayerSessionsRequest.wrap(buildAwsValue())
}
object CreatePlayerSessionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.CreatePlayerSessionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.CreatePlayerSessionsRequest =
      zio.aws.gamelift.model.CreatePlayerSessionsRequest(
        gameSessionId,
        playerIds,
        playerDataMap.map(value => value)
      )
    def gameSessionId: ArnStringModel
    def playerIds: List[NonZeroAndMaxString]
    def playerDataMap: Option[Map[NonZeroAndMaxString, PlayerData]]
    def getGameSessionId: ZIO[Any, Nothing, ArnStringModel] =
      ZIO.succeed(gameSessionId)
    def getPlayerIds: ZIO[Any, Nothing, List[NonZeroAndMaxString]] =
      ZIO.succeed(playerIds)
    def getPlayerDataMap
        : ZIO[Any, AwsError, Map[NonZeroAndMaxString, PlayerData]] =
      AwsError.unwrapOptionField("playerDataMap", playerDataMap)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.CreatePlayerSessionsRequest
  ) extends zio.aws.gamelift.model.CreatePlayerSessionsRequest.ReadOnly {
    override val gameSessionId: ArnStringModel =
      zio.aws.gamelift.model.primitives.ArnStringModel(impl.gameSessionId())
    override val playerIds: List[NonZeroAndMaxString] = impl
      .playerIds()
      .asScala
      .map { item =>
        zio.aws.gamelift.model.primitives.NonZeroAndMaxString(item)
      }
      .toList
    override val playerDataMap: Option[Map[NonZeroAndMaxString, PlayerData]] =
      scala
        .Option(impl.playerDataMap())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.gamelift.model.primitives.NonZeroAndMaxString(
                key
              ) -> zio.aws.gamelift.model.primitives.PlayerData(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.CreatePlayerSessionsRequest
  ): zio.aws.gamelift.model.CreatePlayerSessionsRequest.ReadOnly = new Wrapper(
    impl
  )
}
