package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreatePlayerSessionsResponse(
    playerSessions: Option[Iterable[zio.aws.gamelift.model.PlayerSession]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.CreatePlayerSessionsResponse = {
    import CreatePlayerSessionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.CreatePlayerSessionsResponse
      .builder()
      .optionallyWith(
        playerSessions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.playerSessions)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.CreatePlayerSessionsResponse.ReadOnly =
    zio.aws.gamelift.model.CreatePlayerSessionsResponse.wrap(buildAwsValue())
}
object CreatePlayerSessionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.CreatePlayerSessionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.CreatePlayerSessionsResponse =
      zio.aws.gamelift.model.CreatePlayerSessionsResponse(
        playerSessions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def playerSessions
        : Option[List[zio.aws.gamelift.model.PlayerSession.ReadOnly]]
    def getPlayerSessions: ZIO[Any, AwsError, List[
      zio.aws.gamelift.model.PlayerSession.ReadOnly
    ]] = AwsError.unwrapOptionField("playerSessions", playerSessions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.CreatePlayerSessionsResponse
  ) extends zio.aws.gamelift.model.CreatePlayerSessionsResponse.ReadOnly {
    override val playerSessions
        : Option[List[zio.aws.gamelift.model.PlayerSession.ReadOnly]] = scala
      .Option(impl.playerSessions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.gamelift.model.PlayerSession.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.CreatePlayerSessionsResponse
  ): zio.aws.gamelift.model.CreatePlayerSessionsResponse.ReadOnly = new Wrapper(
    impl
  )
}
