package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateScriptResponse(
    script: Option[zio.aws.gamelift.model.Script] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.CreateScriptResponse = {
    import CreateScriptResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.CreateScriptResponse
      .builder()
      .optionallyWith(script.map(value => value.buildAwsValue()))(_.script)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.CreateScriptResponse.ReadOnly =
    zio.aws.gamelift.model.CreateScriptResponse.wrap(buildAwsValue())
}
object CreateScriptResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.CreateScriptResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.CreateScriptResponse =
      zio.aws.gamelift.model
        .CreateScriptResponse(script.map(value => value.asEditable))
    def script: Option[zio.aws.gamelift.model.Script.ReadOnly]
    def getScript: ZIO[Any, AwsError, zio.aws.gamelift.model.Script.ReadOnly] =
      AwsError.unwrapOptionField("script", script)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.CreateScriptResponse
  ) extends zio.aws.gamelift.model.CreateScriptResponse.ReadOnly {
    override val script: Option[zio.aws.gamelift.model.Script.ReadOnly] = scala
      .Option(impl.script())
      .map(value => zio.aws.gamelift.model.Script.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.CreateScriptResponse
  ): zio.aws.gamelift.model.CreateScriptResponse.ReadOnly = new Wrapper(impl)
}
