package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateVpcPeeringAuthorizationResponse(
    vpcPeeringAuthorization: Option[
      zio.aws.gamelift.model.VpcPeeringAuthorization
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.CreateVpcPeeringAuthorizationResponse = {
    import CreateVpcPeeringAuthorizationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.CreateVpcPeeringAuthorizationResponse
      .builder()
      .optionallyWith(
        vpcPeeringAuthorization.map(value => value.buildAwsValue())
      )(_.vpcPeeringAuthorization)
      .build()
  }
  def asReadOnly
      : zio.aws.gamelift.model.CreateVpcPeeringAuthorizationResponse.ReadOnly =
    zio.aws.gamelift.model.CreateVpcPeeringAuthorizationResponse
      .wrap(buildAwsValue())
}
object CreateVpcPeeringAuthorizationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.CreateVpcPeeringAuthorizationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.gamelift.model.CreateVpcPeeringAuthorizationResponse =
      zio.aws.gamelift.model.CreateVpcPeeringAuthorizationResponse(
        vpcPeeringAuthorization.map(value => value.asEditable)
      )
    def vpcPeeringAuthorization
        : Option[zio.aws.gamelift.model.VpcPeeringAuthorization.ReadOnly]
    def getVpcPeeringAuthorization: ZIO[
      Any,
      AwsError,
      zio.aws.gamelift.model.VpcPeeringAuthorization.ReadOnly
    ] = AwsError.unwrapOptionField(
      "vpcPeeringAuthorization",
      vpcPeeringAuthorization
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.CreateVpcPeeringAuthorizationResponse
  ) extends zio.aws.gamelift.model.CreateVpcPeeringAuthorizationResponse.ReadOnly {
    override val vpcPeeringAuthorization
        : Option[zio.aws.gamelift.model.VpcPeeringAuthorization.ReadOnly] =
      scala
        .Option(impl.vpcPeeringAuthorization())
        .map(value =>
          zio.aws.gamelift.model.VpcPeeringAuthorization.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.CreateVpcPeeringAuthorizationResponse
  ): zio.aws.gamelift.model.CreateVpcPeeringAuthorizationResponse.ReadOnly =
    new Wrapper(impl)
}
