package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.gamelift.model.primitives.NonEmptyString
import scala.jdk.CollectionConverters._
final case class Credentials(
    accessKeyId: Option[NonEmptyString] = None,
    secretAccessKey: Option[NonEmptyString] = None,
    sessionToken: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.Credentials = {
    import Credentials.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.Credentials
      .builder()
      .optionallyWith(
        accessKeyId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.accessKeyId)
      .optionallyWith(
        secretAccessKey.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.secretAccessKey)
      .optionallyWith(
        sessionToken.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.sessionToken)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.Credentials.ReadOnly =
    zio.aws.gamelift.model.Credentials.wrap(buildAwsValue())
}
object Credentials {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.Credentials
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.Credentials =
      zio.aws.gamelift.model.Credentials(
        accessKeyId.map(value => value),
        secretAccessKey.map(value => value),
        sessionToken.map(value => value)
      )
    def accessKeyId: Option[NonEmptyString]
    def secretAccessKey: Option[NonEmptyString]
    def sessionToken: Option[NonEmptyString]
    def getAccessKeyId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("accessKeyId", accessKeyId)
    def getSecretAccessKey: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("secretAccessKey", secretAccessKey)
    def getSessionToken: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("sessionToken", sessionToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.Credentials
  ) extends zio.aws.gamelift.model.Credentials.ReadOnly {
    override val accessKeyId: Option[NonEmptyString] = scala
      .Option(impl.accessKeyId())
      .map(value => zio.aws.gamelift.model.primitives.NonEmptyString(value))
    override val secretAccessKey: Option[NonEmptyString] = scala
      .Option(impl.secretAccessKey())
      .map(value => zio.aws.gamelift.model.primitives.NonEmptyString(value))
    override val sessionToken: Option[NonEmptyString] = scala
      .Option(impl.sessionToken())
      .map(value => zio.aws.gamelift.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.Credentials
  ): zio.aws.gamelift.model.Credentials.ReadOnly = new Wrapper(impl)
}
