package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.gamelift.model.primitives.AliasIdOrArn
import scala.jdk.CollectionConverters._
final case class DeleteAliasRequest(aliasId: AliasIdOrArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.DeleteAliasRequest = {
    import DeleteAliasRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.DeleteAliasRequest
      .builder()
      .aliasId(AliasIdOrArn.unwrap(aliasId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.DeleteAliasRequest.ReadOnly =
    zio.aws.gamelift.model.DeleteAliasRequest.wrap(buildAwsValue())
}
object DeleteAliasRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.DeleteAliasRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.DeleteAliasRequest =
      zio.aws.gamelift.model.DeleteAliasRequest(aliasId)
    def aliasId: AliasIdOrArn
    def getAliasId: ZIO[Any, Nothing, AliasIdOrArn] = ZIO.succeed(aliasId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.DeleteAliasRequest
  ) extends zio.aws.gamelift.model.DeleteAliasRequest.ReadOnly {
    override val aliasId: AliasIdOrArn =
      zio.aws.gamelift.model.primitives.AliasIdOrArn(impl.aliasId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.DeleteAliasRequest
  ): zio.aws.gamelift.model.DeleteAliasRequest.ReadOnly = new Wrapper(impl)
}
