package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.gamelift.model.primitives.BuildIdOrArn
import scala.jdk.CollectionConverters._
final case class DeleteBuildRequest(buildId: BuildIdOrArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.DeleteBuildRequest = {
    import DeleteBuildRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.DeleteBuildRequest
      .builder()
      .buildId(BuildIdOrArn.unwrap(buildId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.DeleteBuildRequest.ReadOnly =
    zio.aws.gamelift.model.DeleteBuildRequest.wrap(buildAwsValue())
}
object DeleteBuildRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.DeleteBuildRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.DeleteBuildRequest =
      zio.aws.gamelift.model.DeleteBuildRequest(buildId)
    def buildId: BuildIdOrArn
    def getBuildId: ZIO[Any, Nothing, BuildIdOrArn] = ZIO.succeed(buildId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.DeleteBuildRequest
  ) extends zio.aws.gamelift.model.DeleteBuildRequest.ReadOnly {
    override val buildId: BuildIdOrArn =
      zio.aws.gamelift.model.primitives.BuildIdOrArn(impl.buildId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.DeleteBuildRequest
  ): zio.aws.gamelift.model.DeleteBuildRequest.ReadOnly = new Wrapper(impl)
}
