package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.gamelift.model.primitives.{LocationStringModel, FleetIdOrArn}
import scala.jdk.CollectionConverters._
final case class DeleteFleetLocationsRequest(
    fleetId: FleetIdOrArn,
    locations: Iterable[LocationStringModel]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.DeleteFleetLocationsRequest = {
    import DeleteFleetLocationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.DeleteFleetLocationsRequest
      .builder()
      .fleetId(FleetIdOrArn.unwrap(fleetId): java.lang.String)
      .locations(locations.map { item =>
        LocationStringModel.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.DeleteFleetLocationsRequest.ReadOnly =
    zio.aws.gamelift.model.DeleteFleetLocationsRequest.wrap(buildAwsValue())
}
object DeleteFleetLocationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.DeleteFleetLocationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.DeleteFleetLocationsRequest =
      zio.aws.gamelift.model.DeleteFleetLocationsRequest(fleetId, locations)
    def fleetId: FleetIdOrArn
    def locations: List[LocationStringModel]
    def getFleetId: ZIO[Any, Nothing, FleetIdOrArn] = ZIO.succeed(fleetId)
    def getLocations: ZIO[Any, Nothing, List[LocationStringModel]] =
      ZIO.succeed(locations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.DeleteFleetLocationsRequest
  ) extends zio.aws.gamelift.model.DeleteFleetLocationsRequest.ReadOnly {
    override val fleetId: FleetIdOrArn =
      zio.aws.gamelift.model.primitives.FleetIdOrArn(impl.fleetId())
    override val locations: List[LocationStringModel] = impl
      .locations()
      .asScala
      .map { item =>
        zio.aws.gamelift.model.primitives.LocationStringModel(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.DeleteFleetLocationsRequest
  ): zio.aws.gamelift.model.DeleteFleetLocationsRequest.ReadOnly = new Wrapper(
    impl
  )
}
