package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.gamelift.model.primitives.FleetIdOrArn
import scala.jdk.CollectionConverters._
final case class DeleteFleetRequest(fleetId: FleetIdOrArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.DeleteFleetRequest = {
    import DeleteFleetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.DeleteFleetRequest
      .builder()
      .fleetId(FleetIdOrArn.unwrap(fleetId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.DeleteFleetRequest.ReadOnly =
    zio.aws.gamelift.model.DeleteFleetRequest.wrap(buildAwsValue())
}
object DeleteFleetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.DeleteFleetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.DeleteFleetRequest =
      zio.aws.gamelift.model.DeleteFleetRequest(fleetId)
    def fleetId: FleetIdOrArn
    def getFleetId: ZIO[Any, Nothing, FleetIdOrArn] = ZIO.succeed(fleetId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.DeleteFleetRequest
  ) extends zio.aws.gamelift.model.DeleteFleetRequest.ReadOnly {
    override val fleetId: FleetIdOrArn =
      zio.aws.gamelift.model.primitives.FleetIdOrArn(impl.fleetId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.DeleteFleetRequest
  ): zio.aws.gamelift.model.DeleteFleetRequest.ReadOnly = new Wrapper(impl)
}
