package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.gamelift.model.primitives.GameSessionQueueNameOrArn
import scala.jdk.CollectionConverters._
final case class DeleteGameSessionQueueRequest(
    name: GameSessionQueueNameOrArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.DeleteGameSessionQueueRequest = {
    import DeleteGameSessionQueueRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.DeleteGameSessionQueueRequest
      .builder()
      .name(GameSessionQueueNameOrArn.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.gamelift.model.DeleteGameSessionQueueRequest.ReadOnly =
    zio.aws.gamelift.model.DeleteGameSessionQueueRequest.wrap(buildAwsValue())
}
object DeleteGameSessionQueueRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.DeleteGameSessionQueueRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.DeleteGameSessionQueueRequest =
      zio.aws.gamelift.model.DeleteGameSessionQueueRequest(name)
    def name: GameSessionQueueNameOrArn
    def getName: ZIO[Any, Nothing, GameSessionQueueNameOrArn] =
      ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.DeleteGameSessionQueueRequest
  ) extends zio.aws.gamelift.model.DeleteGameSessionQueueRequest.ReadOnly {
    override val name: GameSessionQueueNameOrArn =
      zio.aws.gamelift.model.primitives.GameSessionQueueNameOrArn(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.DeleteGameSessionQueueRequest
  ): zio.aws.gamelift.model.DeleteGameSessionQueueRequest.ReadOnly =
    new Wrapper(impl)
}
