package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.gamelift.model.primitives.ScriptIdOrArn
import scala.jdk.CollectionConverters._
final case class DeleteScriptRequest(scriptId: ScriptIdOrArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.DeleteScriptRequest = {
    import DeleteScriptRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.DeleteScriptRequest
      .builder()
      .scriptId(ScriptIdOrArn.unwrap(scriptId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.DeleteScriptRequest.ReadOnly =
    zio.aws.gamelift.model.DeleteScriptRequest.wrap(buildAwsValue())
}
object DeleteScriptRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.DeleteScriptRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.DeleteScriptRequest =
      zio.aws.gamelift.model.DeleteScriptRequest(scriptId)
    def scriptId: ScriptIdOrArn
    def getScriptId: ZIO[Any, Nothing, ScriptIdOrArn] = ZIO.succeed(scriptId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.DeleteScriptRequest
  ) extends zio.aws.gamelift.model.DeleteScriptRequest.ReadOnly {
    override val scriptId: ScriptIdOrArn =
      zio.aws.gamelift.model.primitives.ScriptIdOrArn(impl.scriptId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.DeleteScriptRequest
  ): zio.aws.gamelift.model.DeleteScriptRequest.ReadOnly = new Wrapper(impl)
}
