package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.gamelift.model.primitives.{NonZeroAndMaxString, FleetId}
import scala.jdk.CollectionConverters._
final case class DeleteVpcPeeringConnectionRequest(
    fleetId: FleetId,
    vpcPeeringConnectionId: NonZeroAndMaxString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.DeleteVpcPeeringConnectionRequest = {
    import DeleteVpcPeeringConnectionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.DeleteVpcPeeringConnectionRequest
      .builder()
      .fleetId(FleetId.unwrap(fleetId): java.lang.String)
      .vpcPeeringConnectionId(
        NonZeroAndMaxString.unwrap(vpcPeeringConnectionId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.gamelift.model.DeleteVpcPeeringConnectionRequest.ReadOnly =
    zio.aws.gamelift.model.DeleteVpcPeeringConnectionRequest
      .wrap(buildAwsValue())
}
object DeleteVpcPeeringConnectionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.DeleteVpcPeeringConnectionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.DeleteVpcPeeringConnectionRequest =
      zio.aws.gamelift.model
        .DeleteVpcPeeringConnectionRequest(fleetId, vpcPeeringConnectionId)
    def fleetId: FleetId
    def vpcPeeringConnectionId: NonZeroAndMaxString
    def getFleetId: ZIO[Any, Nothing, FleetId] = ZIO.succeed(fleetId)
    def getVpcPeeringConnectionId: ZIO[Any, Nothing, NonZeroAndMaxString] =
      ZIO.succeed(vpcPeeringConnectionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.DeleteVpcPeeringConnectionRequest
  ) extends zio.aws.gamelift.model.DeleteVpcPeeringConnectionRequest.ReadOnly {
    override val fleetId: FleetId =
      zio.aws.gamelift.model.primitives.FleetId(impl.fleetId())
    override val vpcPeeringConnectionId: NonZeroAndMaxString =
      zio.aws.gamelift.model.primitives
        .NonZeroAndMaxString(impl.vpcPeeringConnectionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.DeleteVpcPeeringConnectionRequest
  ): zio.aws.gamelift.model.DeleteVpcPeeringConnectionRequest.ReadOnly =
    new Wrapper(impl)
}
