package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.gamelift.model.primitives.AliasIdOrArn
import scala.jdk.CollectionConverters._
final case class DescribeAliasRequest(aliasId: AliasIdOrArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.DescribeAliasRequest = {
    import DescribeAliasRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.DescribeAliasRequest
      .builder()
      .aliasId(AliasIdOrArn.unwrap(aliasId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.DescribeAliasRequest.ReadOnly =
    zio.aws.gamelift.model.DescribeAliasRequest.wrap(buildAwsValue())
}
object DescribeAliasRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.DescribeAliasRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.DescribeAliasRequest =
      zio.aws.gamelift.model.DescribeAliasRequest(aliasId)
    def aliasId: AliasIdOrArn
    def getAliasId: ZIO[Any, Nothing, AliasIdOrArn] = ZIO.succeed(aliasId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeAliasRequest
  ) extends zio.aws.gamelift.model.DescribeAliasRequest.ReadOnly {
    override val aliasId: AliasIdOrArn =
      zio.aws.gamelift.model.primitives.AliasIdOrArn(impl.aliasId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeAliasRequest
  ): zio.aws.gamelift.model.DescribeAliasRequest.ReadOnly = new Wrapper(impl)
}
