package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeAliasResponse(
    alias: Option[zio.aws.gamelift.model.Alias] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.DescribeAliasResponse = {
    import DescribeAliasResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.DescribeAliasResponse
      .builder()
      .optionallyWith(alias.map(value => value.buildAwsValue()))(_.alias)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.DescribeAliasResponse.ReadOnly =
    zio.aws.gamelift.model.DescribeAliasResponse.wrap(buildAwsValue())
}
object DescribeAliasResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.DescribeAliasResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.DescribeAliasResponse =
      zio.aws.gamelift.model
        .DescribeAliasResponse(alias.map(value => value.asEditable))
    def alias: Option[zio.aws.gamelift.model.Alias.ReadOnly]
    def getAlias: ZIO[Any, AwsError, zio.aws.gamelift.model.Alias.ReadOnly] =
      AwsError.unwrapOptionField("alias", alias)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeAliasResponse
  ) extends zio.aws.gamelift.model.DescribeAliasResponse.ReadOnly {
    override val alias: Option[zio.aws.gamelift.model.Alias.ReadOnly] = scala
      .Option(impl.alias())
      .map(value => zio.aws.gamelift.model.Alias.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeAliasResponse
  ): zio.aws.gamelift.model.DescribeAliasResponse.ReadOnly = new Wrapper(impl)
}
