package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeBuildResponse(
    build: Option[zio.aws.gamelift.model.Build] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.DescribeBuildResponse = {
    import DescribeBuildResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.DescribeBuildResponse
      .builder()
      .optionallyWith(build.map(value => value.buildAwsValue()))(_.build)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.DescribeBuildResponse.ReadOnly =
    zio.aws.gamelift.model.DescribeBuildResponse.wrap(buildAwsValue())
}
object DescribeBuildResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.DescribeBuildResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.DescribeBuildResponse =
      zio.aws.gamelift.model
        .DescribeBuildResponse(build.map(value => value.asEditable))
    def build: Option[zio.aws.gamelift.model.Build.ReadOnly]
    def getBuild: ZIO[Any, AwsError, zio.aws.gamelift.model.Build.ReadOnly] =
      AwsError.unwrapOptionField("build", build)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeBuildResponse
  ) extends zio.aws.gamelift.model.DescribeBuildResponse.ReadOnly {
    override val build: Option[zio.aws.gamelift.model.Build.ReadOnly] = scala
      .Option(impl.build())
      .map(value => zio.aws.gamelift.model.Build.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeBuildResponse
  ): zio.aws.gamelift.model.DescribeBuildResponse.ReadOnly = new Wrapper(impl)
}
