package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.gamelift.model.primitives.LocationStringModel
import scala.jdk.CollectionConverters._
final case class DescribeEc2InstanceLimitsRequest(
    ec2InstanceType: Option[zio.aws.gamelift.model.EC2InstanceType] = None,
    location: Option[LocationStringModel] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.DescribeEc2InstanceLimitsRequest = {
    import DescribeEc2InstanceLimitsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.DescribeEc2InstanceLimitsRequest
      .builder()
      .optionallyWith(ec2InstanceType.map(value => value.unwrap))(
        _.ec2InstanceType
      )
      .optionallyWith(
        location.map(value =>
          LocationStringModel.unwrap(value): java.lang.String
        )
      )(_.location)
      .build()
  }
  def asReadOnly
      : zio.aws.gamelift.model.DescribeEc2InstanceLimitsRequest.ReadOnly =
    zio.aws.gamelift.model.DescribeEc2InstanceLimitsRequest
      .wrap(buildAwsValue())
}
object DescribeEc2InstanceLimitsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.DescribeEc2InstanceLimitsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.DescribeEc2InstanceLimitsRequest =
      zio.aws.gamelift.model.DescribeEc2InstanceLimitsRequest(
        ec2InstanceType.map(value => value),
        location.map(value => value)
      )
    def ec2InstanceType: Option[zio.aws.gamelift.model.EC2InstanceType]
    def location: Option[LocationStringModel]
    def getEc2InstanceType
        : ZIO[Any, AwsError, zio.aws.gamelift.model.EC2InstanceType] =
      AwsError.unwrapOptionField("ec2InstanceType", ec2InstanceType)
    def getLocation: ZIO[Any, AwsError, LocationStringModel] =
      AwsError.unwrapOptionField("location", location)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeEc2InstanceLimitsRequest
  ) extends zio.aws.gamelift.model.DescribeEc2InstanceLimitsRequest.ReadOnly {
    override val ec2InstanceType
        : Option[zio.aws.gamelift.model.EC2InstanceType] = scala
      .Option(impl.ec2InstanceType())
      .map(value => zio.aws.gamelift.model.EC2InstanceType.wrap(value))
    override val location: Option[LocationStringModel] = scala
      .Option(impl.location())
      .map(value =>
        zio.aws.gamelift.model.primitives.LocationStringModel(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeEc2InstanceLimitsRequest
  ): zio.aws.gamelift.model.DescribeEc2InstanceLimitsRequest.ReadOnly =
    new Wrapper(impl)
}
