package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeEc2InstanceLimitsResponse(
    ec2InstanceLimits: Option[
      Iterable[zio.aws.gamelift.model.EC2InstanceLimit]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.DescribeEc2InstanceLimitsResponse = {
    import DescribeEc2InstanceLimitsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.DescribeEc2InstanceLimitsResponse
      .builder()
      .optionallyWith(
        ec2InstanceLimits.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ec2InstanceLimits)
      .build()
  }
  def asReadOnly
      : zio.aws.gamelift.model.DescribeEc2InstanceLimitsResponse.ReadOnly =
    zio.aws.gamelift.model.DescribeEc2InstanceLimitsResponse
      .wrap(buildAwsValue())
}
object DescribeEc2InstanceLimitsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.DescribeEc2InstanceLimitsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.DescribeEc2InstanceLimitsResponse =
      zio.aws.gamelift.model.DescribeEc2InstanceLimitsResponse(
        ec2InstanceLimits.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def ec2InstanceLimits
        : Option[List[zio.aws.gamelift.model.EC2InstanceLimit.ReadOnly]]
    def getEc2InstanceLimits: ZIO[Any, AwsError, List[
      zio.aws.gamelift.model.EC2InstanceLimit.ReadOnly
    ]] = AwsError.unwrapOptionField("ec2InstanceLimits", ec2InstanceLimits)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeEc2InstanceLimitsResponse
  ) extends zio.aws.gamelift.model.DescribeEc2InstanceLimitsResponse.ReadOnly {
    override val ec2InstanceLimits
        : Option[List[zio.aws.gamelift.model.EC2InstanceLimit.ReadOnly]] = scala
      .Option(impl.ec2InstanceLimits())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.gamelift.model.EC2InstanceLimit.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeEc2InstanceLimitsResponse
  ): zio.aws.gamelift.model.DescribeEc2InstanceLimitsResponse.ReadOnly =
    new Wrapper(impl)
}
