package zio.aws.gamelift.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.gamelift.model.primitives.{
  NonZeroAndMaxString,
  PositiveInteger,
  LocationStringModel,
  FleetIdOrArn
}
import scala.jdk.CollectionConverters._
final case class DescribeFleetLocationAttributesRequest(
    fleetId: FleetIdOrArn,
    locations: Option[Iterable[LocationStringModel]] = None,
    limit: Option[PositiveInteger] = None,
    nextToken: Option[NonZeroAndMaxString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.DescribeFleetLocationAttributesRequest = {
    import DescribeFleetLocationAttributesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.DescribeFleetLocationAttributesRequest
      .builder()
      .fleetId(FleetIdOrArn.unwrap(fleetId): java.lang.String)
      .optionallyWith(
        locations.map(value =>
          value.map { item =>
            LocationStringModel.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.locations)
      .optionallyWith(
        limit.map(value => PositiveInteger.unwrap(value): Integer)
      )(_.limit)
      .optionallyWith(
        nextToken.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.gamelift.model.DescribeFleetLocationAttributesRequest.ReadOnly =
    zio.aws.gamelift.model.DescribeFleetLocationAttributesRequest
      .wrap(buildAwsValue())
}
object DescribeFleetLocationAttributesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.DescribeFleetLocationAttributesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.gamelift.model.DescribeFleetLocationAttributesRequest =
      zio.aws.gamelift.model.DescribeFleetLocationAttributesRequest(
        fleetId,
        locations.map(value => value),
        limit.map(value => value),
        nextToken.map(value => value)
      )
    def fleetId: FleetIdOrArn
    def locations: Option[List[LocationStringModel]]
    def limit: Option[PositiveInteger]
    def nextToken: Option[NonZeroAndMaxString]
    def getFleetId: ZIO[Any, Nothing, FleetIdOrArn] = ZIO.succeed(fleetId)
    def getLocations: ZIO[Any, AwsError, List[LocationStringModel]] =
      AwsError.unwrapOptionField("locations", locations)
    def getLimit: ZIO[Any, AwsError, PositiveInteger] =
      AwsError.unwrapOptionField("limit", limit)
    def getNextToken: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeFleetLocationAttributesRequest
  ) extends zio.aws.gamelift.model.DescribeFleetLocationAttributesRequest.ReadOnly {
    override val fleetId: FleetIdOrArn =
      zio.aws.gamelift.model.primitives.FleetIdOrArn(impl.fleetId())
    override val locations: Option[List[LocationStringModel]] = scala
      .Option(impl.locations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.gamelift.model.primitives.LocationStringModel(item)
        }.toList
      )
    override val limit: Option[PositiveInteger] = scala
      .Option(impl.limit())
      .map(value => zio.aws.gamelift.model.primitives.PositiveInteger(value))
    override val nextToken: Option[NonZeroAndMaxString] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeFleetLocationAttributesRequest
  ): zio.aws.gamelift.model.DescribeFleetLocationAttributesRequest.ReadOnly =
    new Wrapper(impl)
}
