package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.gamelift.model.primitives.{
  NonZeroAndMaxString,
  FleetArn,
  FleetIdOrArn
}
import scala.jdk.CollectionConverters._
final case class DescribeFleetLocationAttributesResponse(
    fleetId: Option[FleetIdOrArn] = None,
    fleetArn: Option[FleetArn] = None,
    locationAttributes: Option[
      Iterable[zio.aws.gamelift.model.LocationAttributes]
    ] = None,
    nextToken: Option[NonZeroAndMaxString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.DescribeFleetLocationAttributesResponse = {
    import DescribeFleetLocationAttributesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.DescribeFleetLocationAttributesResponse
      .builder()
      .optionallyWith(
        fleetId.map(value => FleetIdOrArn.unwrap(value): java.lang.String)
      )(_.fleetId)
      .optionallyWith(
        fleetArn.map(value => FleetArn.unwrap(value): java.lang.String)
      )(_.fleetArn)
      .optionallyWith(
        locationAttributes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.locationAttributes)
      .optionallyWith(
        nextToken.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.gamelift.model.DescribeFleetLocationAttributesResponse.ReadOnly =
    zio.aws.gamelift.model.DescribeFleetLocationAttributesResponse
      .wrap(buildAwsValue())
}
object DescribeFleetLocationAttributesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.DescribeFleetLocationAttributesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.gamelift.model.DescribeFleetLocationAttributesResponse =
      zio.aws.gamelift.model.DescribeFleetLocationAttributesResponse(
        fleetId.map(value => value),
        fleetArn.map(value => value),
        locationAttributes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def fleetId: Option[FleetIdOrArn]
    def fleetArn: Option[FleetArn]
    def locationAttributes
        : Option[List[zio.aws.gamelift.model.LocationAttributes.ReadOnly]]
    def nextToken: Option[NonZeroAndMaxString]
    def getFleetId: ZIO[Any, AwsError, FleetIdOrArn] =
      AwsError.unwrapOptionField("fleetId", fleetId)
    def getFleetArn: ZIO[Any, AwsError, FleetArn] =
      AwsError.unwrapOptionField("fleetArn", fleetArn)
    def getLocationAttributes: ZIO[Any, AwsError, List[
      zio.aws.gamelift.model.LocationAttributes.ReadOnly
    ]] = AwsError.unwrapOptionField("locationAttributes", locationAttributes)
    def getNextToken: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeFleetLocationAttributesResponse
  ) extends zio.aws.gamelift.model.DescribeFleetLocationAttributesResponse.ReadOnly {
    override val fleetId: Option[FleetIdOrArn] = scala
      .Option(impl.fleetId())
      .map(value => zio.aws.gamelift.model.primitives.FleetIdOrArn(value))
    override val fleetArn: Option[FleetArn] = scala
      .Option(impl.fleetArn())
      .map(value => zio.aws.gamelift.model.primitives.FleetArn(value))
    override val locationAttributes
        : Option[List[zio.aws.gamelift.model.LocationAttributes.ReadOnly]] =
      scala
        .Option(impl.locationAttributes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.gamelift.model.LocationAttributes.wrap(item)
          }.toList
        )
    override val nextToken: Option[NonZeroAndMaxString] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeFleetLocationAttributesResponse
  ): zio.aws.gamelift.model.DescribeFleetLocationAttributesResponse.ReadOnly =
    new Wrapper(impl)
}
