package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.gamelift.model.primitives.{LocationStringModel, FleetIdOrArn}
import scala.jdk.CollectionConverters._
final case class DescribeFleetLocationUtilizationRequest(
    fleetId: FleetIdOrArn,
    location: LocationStringModel
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.DescribeFleetLocationUtilizationRequest = {
    import DescribeFleetLocationUtilizationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.DescribeFleetLocationUtilizationRequest
      .builder()
      .fleetId(FleetIdOrArn.unwrap(fleetId): java.lang.String)
      .location(LocationStringModel.unwrap(location): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.gamelift.model.DescribeFleetLocationUtilizationRequest.ReadOnly =
    zio.aws.gamelift.model.DescribeFleetLocationUtilizationRequest
      .wrap(buildAwsValue())
}
object DescribeFleetLocationUtilizationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.DescribeFleetLocationUtilizationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.gamelift.model.DescribeFleetLocationUtilizationRequest =
      zio.aws.gamelift.model
        .DescribeFleetLocationUtilizationRequest(fleetId, location)
    def fleetId: FleetIdOrArn
    def location: LocationStringModel
    def getFleetId: ZIO[Any, Nothing, FleetIdOrArn] = ZIO.succeed(fleetId)
    def getLocation: ZIO[Any, Nothing, LocationStringModel] =
      ZIO.succeed(location)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeFleetLocationUtilizationRequest
  ) extends zio.aws.gamelift.model.DescribeFleetLocationUtilizationRequest.ReadOnly {
    override val fleetId: FleetIdOrArn =
      zio.aws.gamelift.model.primitives.FleetIdOrArn(impl.fleetId())
    override val location: LocationStringModel =
      zio.aws.gamelift.model.primitives.LocationStringModel(impl.location())
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeFleetLocationUtilizationRequest
  ): zio.aws.gamelift.model.DescribeFleetLocationUtilizationRequest.ReadOnly =
    new Wrapper(impl)
}
