package zio.aws.gamelift.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.gamelift.model.primitives.{
  NonZeroAndMaxString,
  PositiveInteger,
  FleetIdOrArn
}
import scala.jdk.CollectionConverters._
final case class DescribeFleetUtilizationRequest(
    fleetIds: Option[Iterable[FleetIdOrArn]] = None,
    limit: Option[PositiveInteger] = None,
    nextToken: Option[NonZeroAndMaxString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.DescribeFleetUtilizationRequest = {
    import DescribeFleetUtilizationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.DescribeFleetUtilizationRequest
      .builder()
      .optionallyWith(
        fleetIds.map(value =>
          value.map { item =>
            FleetIdOrArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.fleetIds)
      .optionallyWith(
        limit.map(value => PositiveInteger.unwrap(value): Integer)
      )(_.limit)
      .optionallyWith(
        nextToken.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.gamelift.model.DescribeFleetUtilizationRequest.ReadOnly =
    zio.aws.gamelift.model.DescribeFleetUtilizationRequest.wrap(buildAwsValue())
}
object DescribeFleetUtilizationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.DescribeFleetUtilizationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.DescribeFleetUtilizationRequest =
      zio.aws.gamelift.model.DescribeFleetUtilizationRequest(
        fleetIds.map(value => value),
        limit.map(value => value),
        nextToken.map(value => value)
      )
    def fleetIds: Option[List[FleetIdOrArn]]
    def limit: Option[PositiveInteger]
    def nextToken: Option[NonZeroAndMaxString]
    def getFleetIds: ZIO[Any, AwsError, List[FleetIdOrArn]] =
      AwsError.unwrapOptionField("fleetIds", fleetIds)
    def getLimit: ZIO[Any, AwsError, PositiveInteger] =
      AwsError.unwrapOptionField("limit", limit)
    def getNextToken: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeFleetUtilizationRequest
  ) extends zio.aws.gamelift.model.DescribeFleetUtilizationRequest.ReadOnly {
    override val fleetIds: Option[List[FleetIdOrArn]] = scala
      .Option(impl.fleetIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.gamelift.model.primitives.FleetIdOrArn(item)
        }.toList
      )
    override val limit: Option[PositiveInteger] = scala
      .Option(impl.limit())
      .map(value => zio.aws.gamelift.model.primitives.PositiveInteger(value))
    override val nextToken: Option[NonZeroAndMaxString] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeFleetUtilizationRequest
  ): zio.aws.gamelift.model.DescribeFleetUtilizationRequest.ReadOnly =
    new Wrapper(impl)
}
