package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.gamelift.model.primitives.GameServerGroupNameOrArn
import scala.jdk.CollectionConverters._
final case class DescribeGameServerGroupRequest(
    gameServerGroupName: GameServerGroupNameOrArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.DescribeGameServerGroupRequest = {
    import DescribeGameServerGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.DescribeGameServerGroupRequest
      .builder()
      .gameServerGroupName(
        GameServerGroupNameOrArn.unwrap(gameServerGroupName): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.gamelift.model.DescribeGameServerGroupRequest.ReadOnly =
    zio.aws.gamelift.model.DescribeGameServerGroupRequest.wrap(buildAwsValue())
}
object DescribeGameServerGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.DescribeGameServerGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.DescribeGameServerGroupRequest =
      zio.aws.gamelift.model.DescribeGameServerGroupRequest(gameServerGroupName)
    def gameServerGroupName: GameServerGroupNameOrArn
    def getGameServerGroupName: ZIO[Any, Nothing, GameServerGroupNameOrArn] =
      ZIO.succeed(gameServerGroupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeGameServerGroupRequest
  ) extends zio.aws.gamelift.model.DescribeGameServerGroupRequest.ReadOnly {
    override val gameServerGroupName: GameServerGroupNameOrArn =
      zio.aws.gamelift.model.primitives
        .GameServerGroupNameOrArn(impl.gameServerGroupName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeGameServerGroupRequest
  ): zio.aws.gamelift.model.DescribeGameServerGroupRequest.ReadOnly =
    new Wrapper(impl)
}
