package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeGameServerGroupResponse(
    gameServerGroup: Option[zio.aws.gamelift.model.GameServerGroup] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.DescribeGameServerGroupResponse = {
    import DescribeGameServerGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.DescribeGameServerGroupResponse
      .builder()
      .optionallyWith(gameServerGroup.map(value => value.buildAwsValue()))(
        _.gameServerGroup
      )
      .build()
  }
  def asReadOnly
      : zio.aws.gamelift.model.DescribeGameServerGroupResponse.ReadOnly =
    zio.aws.gamelift.model.DescribeGameServerGroupResponse.wrap(buildAwsValue())
}
object DescribeGameServerGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.DescribeGameServerGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.DescribeGameServerGroupResponse =
      zio.aws.gamelift.model.DescribeGameServerGroupResponse(
        gameServerGroup.map(value => value.asEditable)
      )
    def gameServerGroup: Option[zio.aws.gamelift.model.GameServerGroup.ReadOnly]
    def getGameServerGroup
        : ZIO[Any, AwsError, zio.aws.gamelift.model.GameServerGroup.ReadOnly] =
      AwsError.unwrapOptionField("gameServerGroup", gameServerGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeGameServerGroupResponse
  ) extends zio.aws.gamelift.model.DescribeGameServerGroupResponse.ReadOnly {
    override val gameServerGroup
        : Option[zio.aws.gamelift.model.GameServerGroup.ReadOnly] = scala
      .Option(impl.gameServerGroup())
      .map(value => zio.aws.gamelift.model.GameServerGroup.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeGameServerGroupResponse
  ): zio.aws.gamelift.model.DescribeGameServerGroupResponse.ReadOnly =
    new Wrapper(impl)
}
