package zio.aws.gamelift.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.gamelift.model.primitives.{
  NonZeroAndMaxString,
  PositiveInteger,
  GameSessionQueueNameOrArn
}
import scala.jdk.CollectionConverters._
final case class DescribeGameSessionQueuesRequest(
    names: Option[Iterable[GameSessionQueueNameOrArn]] = None,
    limit: Option[PositiveInteger] = None,
    nextToken: Option[NonZeroAndMaxString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.DescribeGameSessionQueuesRequest = {
    import DescribeGameSessionQueuesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.DescribeGameSessionQueuesRequest
      .builder()
      .optionallyWith(
        names.map(value =>
          value.map { item =>
            GameSessionQueueNameOrArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.names)
      .optionallyWith(
        limit.map(value => PositiveInteger.unwrap(value): Integer)
      )(_.limit)
      .optionallyWith(
        nextToken.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.gamelift.model.DescribeGameSessionQueuesRequest.ReadOnly =
    zio.aws.gamelift.model.DescribeGameSessionQueuesRequest
      .wrap(buildAwsValue())
}
object DescribeGameSessionQueuesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.DescribeGameSessionQueuesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.DescribeGameSessionQueuesRequest =
      zio.aws.gamelift.model.DescribeGameSessionQueuesRequest(
        names.map(value => value),
        limit.map(value => value),
        nextToken.map(value => value)
      )
    def names: Option[List[GameSessionQueueNameOrArn]]
    def limit: Option[PositiveInteger]
    def nextToken: Option[NonZeroAndMaxString]
    def getNames: ZIO[Any, AwsError, List[GameSessionQueueNameOrArn]] =
      AwsError.unwrapOptionField("names", names)
    def getLimit: ZIO[Any, AwsError, PositiveInteger] =
      AwsError.unwrapOptionField("limit", limit)
    def getNextToken: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeGameSessionQueuesRequest
  ) extends zio.aws.gamelift.model.DescribeGameSessionQueuesRequest.ReadOnly {
    override val names: Option[List[GameSessionQueueNameOrArn]] = scala
      .Option(impl.names())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.gamelift.model.primitives.GameSessionQueueNameOrArn(item)
        }.toList
      )
    override val limit: Option[PositiveInteger] = scala
      .Option(impl.limit())
      .map(value => zio.aws.gamelift.model.primitives.PositiveInteger(value))
    override val nextToken: Option[NonZeroAndMaxString] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeGameSessionQueuesRequest
  ): zio.aws.gamelift.model.DescribeGameSessionQueuesRequest.ReadOnly =
    new Wrapper(impl)
}
