package zio.aws.gamelift.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.gamelift.model.primitives.{
  ArnStringModel,
  FleetIdOrArn,
  PositiveInteger,
  LocationStringModel,
  NonZeroAndMaxString,
  AliasIdOrArn
}
import scala.jdk.CollectionConverters._
final case class DescribeGameSessionsRequest(
    fleetId: Option[FleetIdOrArn] = None,
    gameSessionId: Option[ArnStringModel] = None,
    aliasId: Option[AliasIdOrArn] = None,
    location: Option[LocationStringModel] = None,
    statusFilter: Option[NonZeroAndMaxString] = None,
    limit: Option[PositiveInteger] = None,
    nextToken: Option[NonZeroAndMaxString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.DescribeGameSessionsRequest = {
    import DescribeGameSessionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.DescribeGameSessionsRequest
      .builder()
      .optionallyWith(
        fleetId.map(value => FleetIdOrArn.unwrap(value): java.lang.String)
      )(_.fleetId)
      .optionallyWith(
        gameSessionId.map(value =>
          ArnStringModel.unwrap(value): java.lang.String
        )
      )(_.gameSessionId)
      .optionallyWith(
        aliasId.map(value => AliasIdOrArn.unwrap(value): java.lang.String)
      )(_.aliasId)
      .optionallyWith(
        location.map(value =>
          LocationStringModel.unwrap(value): java.lang.String
        )
      )(_.location)
      .optionallyWith(
        statusFilter.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.statusFilter)
      .optionallyWith(
        limit.map(value => PositiveInteger.unwrap(value): Integer)
      )(_.limit)
      .optionallyWith(
        nextToken.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.DescribeGameSessionsRequest.ReadOnly =
    zio.aws.gamelift.model.DescribeGameSessionsRequest.wrap(buildAwsValue())
}
object DescribeGameSessionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.DescribeGameSessionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.DescribeGameSessionsRequest =
      zio.aws.gamelift.model.DescribeGameSessionsRequest(
        fleetId.map(value => value),
        gameSessionId.map(value => value),
        aliasId.map(value => value),
        location.map(value => value),
        statusFilter.map(value => value),
        limit.map(value => value),
        nextToken.map(value => value)
      )
    def fleetId: Option[FleetIdOrArn]
    def gameSessionId: Option[ArnStringModel]
    def aliasId: Option[AliasIdOrArn]
    def location: Option[LocationStringModel]
    def statusFilter: Option[NonZeroAndMaxString]
    def limit: Option[PositiveInteger]
    def nextToken: Option[NonZeroAndMaxString]
    def getFleetId: ZIO[Any, AwsError, FleetIdOrArn] =
      AwsError.unwrapOptionField("fleetId", fleetId)
    def getGameSessionId: ZIO[Any, AwsError, ArnStringModel] =
      AwsError.unwrapOptionField("gameSessionId", gameSessionId)
    def getAliasId: ZIO[Any, AwsError, AliasIdOrArn] =
      AwsError.unwrapOptionField("aliasId", aliasId)
    def getLocation: ZIO[Any, AwsError, LocationStringModel] =
      AwsError.unwrapOptionField("location", location)
    def getStatusFilter: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("statusFilter", statusFilter)
    def getLimit: ZIO[Any, AwsError, PositiveInteger] =
      AwsError.unwrapOptionField("limit", limit)
    def getNextToken: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeGameSessionsRequest
  ) extends zio.aws.gamelift.model.DescribeGameSessionsRequest.ReadOnly {
    override val fleetId: Option[FleetIdOrArn] = scala
      .Option(impl.fleetId())
      .map(value => zio.aws.gamelift.model.primitives.FleetIdOrArn(value))
    override val gameSessionId: Option[ArnStringModel] = scala
      .Option(impl.gameSessionId())
      .map(value => zio.aws.gamelift.model.primitives.ArnStringModel(value))
    override val aliasId: Option[AliasIdOrArn] = scala
      .Option(impl.aliasId())
      .map(value => zio.aws.gamelift.model.primitives.AliasIdOrArn(value))
    override val location: Option[LocationStringModel] = scala
      .Option(impl.location())
      .map(value =>
        zio.aws.gamelift.model.primitives.LocationStringModel(value)
      )
    override val statusFilter: Option[NonZeroAndMaxString] = scala
      .Option(impl.statusFilter())
      .map(value =>
        zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
      )
    override val limit: Option[PositiveInteger] = scala
      .Option(impl.limit())
      .map(value => zio.aws.gamelift.model.primitives.PositiveInteger(value))
    override val nextToken: Option[NonZeroAndMaxString] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeGameSessionsRequest
  ): zio.aws.gamelift.model.DescribeGameSessionsRequest.ReadOnly = new Wrapper(
    impl
  )
}
