package zio.aws.gamelift.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.gamelift.model.primitives.{
  FleetIdOrArn,
  InstanceId,
  PositiveInteger,
  LocationStringModel,
  NonZeroAndMaxString
}
import scala.jdk.CollectionConverters._
final case class DescribeInstancesRequest(
    fleetId: FleetIdOrArn,
    instanceId: Option[InstanceId] = None,
    limit: Option[PositiveInteger] = None,
    nextToken: Option[NonZeroAndMaxString] = None,
    location: Option[LocationStringModel] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.DescribeInstancesRequest = {
    import DescribeInstancesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.DescribeInstancesRequest
      .builder()
      .fleetId(FleetIdOrArn.unwrap(fleetId): java.lang.String)
      .optionallyWith(
        instanceId.map(value => InstanceId.unwrap(value): java.lang.String)
      )(_.instanceId)
      .optionallyWith(
        limit.map(value => PositiveInteger.unwrap(value): Integer)
      )(_.limit)
      .optionallyWith(
        nextToken.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .optionallyWith(
        location.map(value =>
          LocationStringModel.unwrap(value): java.lang.String
        )
      )(_.location)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.DescribeInstancesRequest.ReadOnly =
    zio.aws.gamelift.model.DescribeInstancesRequest.wrap(buildAwsValue())
}
object DescribeInstancesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.DescribeInstancesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.DescribeInstancesRequest =
      zio.aws.gamelift.model.DescribeInstancesRequest(
        fleetId,
        instanceId.map(value => value),
        limit.map(value => value),
        nextToken.map(value => value),
        location.map(value => value)
      )
    def fleetId: FleetIdOrArn
    def instanceId: Option[InstanceId]
    def limit: Option[PositiveInteger]
    def nextToken: Option[NonZeroAndMaxString]
    def location: Option[LocationStringModel]
    def getFleetId: ZIO[Any, Nothing, FleetIdOrArn] = ZIO.succeed(fleetId)
    def getInstanceId: ZIO[Any, AwsError, InstanceId] =
      AwsError.unwrapOptionField("instanceId", instanceId)
    def getLimit: ZIO[Any, AwsError, PositiveInteger] =
      AwsError.unwrapOptionField("limit", limit)
    def getNextToken: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getLocation: ZIO[Any, AwsError, LocationStringModel] =
      AwsError.unwrapOptionField("location", location)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeInstancesRequest
  ) extends zio.aws.gamelift.model.DescribeInstancesRequest.ReadOnly {
    override val fleetId: FleetIdOrArn =
      zio.aws.gamelift.model.primitives.FleetIdOrArn(impl.fleetId())
    override val instanceId: Option[InstanceId] = scala
      .Option(impl.instanceId())
      .map(value => zio.aws.gamelift.model.primitives.InstanceId(value))
    override val limit: Option[PositiveInteger] = scala
      .Option(impl.limit())
      .map(value => zio.aws.gamelift.model.primitives.PositiveInteger(value))
    override val nextToken: Option[NonZeroAndMaxString] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
      )
    override val location: Option[LocationStringModel] = scala
      .Option(impl.location())
      .map(value =>
        zio.aws.gamelift.model.primitives.LocationStringModel(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeInstancesRequest
  ): zio.aws.gamelift.model.DescribeInstancesRequest.ReadOnly = new Wrapper(
    impl
  )
}
