package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.gamelift.model.primitives.NonZeroAndMaxString
import scala.jdk.CollectionConverters._
final case class DescribeInstancesResponse(
    instances: Option[Iterable[zio.aws.gamelift.model.Instance]] = None,
    nextToken: Option[NonZeroAndMaxString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.DescribeInstancesResponse = {
    import DescribeInstancesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.DescribeInstancesResponse
      .builder()
      .optionallyWith(
        instances.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.instances)
      .optionallyWith(
        nextToken.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.DescribeInstancesResponse.ReadOnly =
    zio.aws.gamelift.model.DescribeInstancesResponse.wrap(buildAwsValue())
}
object DescribeInstancesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.DescribeInstancesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.DescribeInstancesResponse =
      zio.aws.gamelift.model.DescribeInstancesResponse(
        instances.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def instances: Option[List[zio.aws.gamelift.model.Instance.ReadOnly]]
    def nextToken: Option[NonZeroAndMaxString]
    def getInstances
        : ZIO[Any, AwsError, List[zio.aws.gamelift.model.Instance.ReadOnly]] =
      AwsError.unwrapOptionField("instances", instances)
    def getNextToken: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeInstancesResponse
  ) extends zio.aws.gamelift.model.DescribeInstancesResponse.ReadOnly {
    override val instances
        : Option[List[zio.aws.gamelift.model.Instance.ReadOnly]] = scala
      .Option(impl.instances())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.gamelift.model.Instance.wrap(item)
        }.toList
      )
    override val nextToken: Option[NonZeroAndMaxString] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeInstancesResponse
  ): zio.aws.gamelift.model.DescribeInstancesResponse.ReadOnly = new Wrapper(
    impl
  )
}
