package zio.aws.gamelift.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.gamelift.model.primitives.{
  NonZeroAndMaxString,
  PositiveInteger,
  MatchmakingRuleSetName,
  MatchmakingConfigurationName
}
import scala.jdk.CollectionConverters._
final case class DescribeMatchmakingConfigurationsRequest(
    names: Option[Iterable[MatchmakingConfigurationName]] = None,
    ruleSetName: Option[MatchmakingRuleSetName] = None,
    limit: Option[PositiveInteger] = None,
    nextToken: Option[NonZeroAndMaxString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingConfigurationsRequest = {
    import DescribeMatchmakingConfigurationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingConfigurationsRequest
      .builder()
      .optionallyWith(
        names.map(value =>
          value.map { item =>
            MatchmakingConfigurationName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.names)
      .optionallyWith(
        ruleSetName.map(value =>
          MatchmakingRuleSetName.unwrap(value): java.lang.String
        )
      )(_.ruleSetName)
      .optionallyWith(
        limit.map(value => PositiveInteger.unwrap(value): Integer)
      )(_.limit)
      .optionallyWith(
        nextToken.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.gamelift.model.DescribeMatchmakingConfigurationsRequest.ReadOnly =
    zio.aws.gamelift.model.DescribeMatchmakingConfigurationsRequest
      .wrap(buildAwsValue())
}
object DescribeMatchmakingConfigurationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingConfigurationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.gamelift.model.DescribeMatchmakingConfigurationsRequest =
      zio.aws.gamelift.model.DescribeMatchmakingConfigurationsRequest(
        names.map(value => value),
        ruleSetName.map(value => value),
        limit.map(value => value),
        nextToken.map(value => value)
      )
    def names: Option[List[MatchmakingConfigurationName]]
    def ruleSetName: Option[MatchmakingRuleSetName]
    def limit: Option[PositiveInteger]
    def nextToken: Option[NonZeroAndMaxString]
    def getNames: ZIO[Any, AwsError, List[MatchmakingConfigurationName]] =
      AwsError.unwrapOptionField("names", names)
    def getRuleSetName: ZIO[Any, AwsError, MatchmakingRuleSetName] =
      AwsError.unwrapOptionField("ruleSetName", ruleSetName)
    def getLimit: ZIO[Any, AwsError, PositiveInteger] =
      AwsError.unwrapOptionField("limit", limit)
    def getNextToken: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingConfigurationsRequest
  ) extends zio.aws.gamelift.model.DescribeMatchmakingConfigurationsRequest.ReadOnly {
    override val names: Option[List[MatchmakingConfigurationName]] = scala
      .Option(impl.names())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.gamelift.model.primitives.MatchmakingConfigurationName(item)
        }.toList
      )
    override val ruleSetName: Option[MatchmakingRuleSetName] = scala
      .Option(impl.ruleSetName())
      .map(value =>
        zio.aws.gamelift.model.primitives.MatchmakingRuleSetName(value)
      )
    override val limit: Option[PositiveInteger] = scala
      .Option(impl.limit())
      .map(value => zio.aws.gamelift.model.primitives.PositiveInteger(value))
    override val nextToken: Option[NonZeroAndMaxString] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingConfigurationsRequest
  ): zio.aws.gamelift.model.DescribeMatchmakingConfigurationsRequest.ReadOnly =
    new Wrapper(impl)
}
