package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.gamelift.model.primitives.NonZeroAndMaxString
import scala.jdk.CollectionConverters._
final case class DescribeMatchmakingConfigurationsResponse(
    configurations: Option[
      Iterable[zio.aws.gamelift.model.MatchmakingConfiguration]
    ] = None,
    nextToken: Option[NonZeroAndMaxString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingConfigurationsResponse = {
    import DescribeMatchmakingConfigurationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingConfigurationsResponse
      .builder()
      .optionallyWith(
        configurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.configurations)
      .optionallyWith(
        nextToken.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.gamelift.model.DescribeMatchmakingConfigurationsResponse.ReadOnly =
    zio.aws.gamelift.model.DescribeMatchmakingConfigurationsResponse
      .wrap(buildAwsValue())
}
object DescribeMatchmakingConfigurationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingConfigurationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.gamelift.model.DescribeMatchmakingConfigurationsResponse =
      zio.aws.gamelift.model.DescribeMatchmakingConfigurationsResponse(
        configurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def configurations
        : Option[List[zio.aws.gamelift.model.MatchmakingConfiguration.ReadOnly]]
    def nextToken: Option[NonZeroAndMaxString]
    def getConfigurations: ZIO[Any, AwsError, List[
      zio.aws.gamelift.model.MatchmakingConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField("configurations", configurations)
    def getNextToken: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingConfigurationsResponse
  ) extends zio.aws.gamelift.model.DescribeMatchmakingConfigurationsResponse.ReadOnly {
    override val configurations: Option[
      List[zio.aws.gamelift.model.MatchmakingConfiguration.ReadOnly]
    ] = scala
      .Option(impl.configurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.gamelift.model.MatchmakingConfiguration.wrap(item)
        }.toList
      )
    override val nextToken: Option[NonZeroAndMaxString] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingConfigurationsResponse
  ): zio.aws.gamelift.model.DescribeMatchmakingConfigurationsResponse.ReadOnly =
    new Wrapper(impl)
}
