package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.gamelift.model.primitives.NonZeroAndMaxString
import scala.jdk.CollectionConverters._
final case class DescribeMatchmakingRuleSetsResponse(
    ruleSets: Iterable[zio.aws.gamelift.model.MatchmakingRuleSet],
    nextToken: Option[NonZeroAndMaxString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingRuleSetsResponse = {
    import DescribeMatchmakingRuleSetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingRuleSetsResponse
      .builder()
      .ruleSets(ruleSets.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.gamelift.model.DescribeMatchmakingRuleSetsResponse.ReadOnly =
    zio.aws.gamelift.model.DescribeMatchmakingRuleSetsResponse
      .wrap(buildAwsValue())
}
object DescribeMatchmakingRuleSetsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingRuleSetsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.DescribeMatchmakingRuleSetsResponse =
      zio.aws.gamelift.model.DescribeMatchmakingRuleSetsResponse(
        ruleSets.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def ruleSets: List[zio.aws.gamelift.model.MatchmakingRuleSet.ReadOnly]
    def nextToken: Option[NonZeroAndMaxString]
    def getRuleSets: ZIO[Any, Nothing, List[
      zio.aws.gamelift.model.MatchmakingRuleSet.ReadOnly
    ]] = ZIO.succeed(ruleSets)
    def getNextToken: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingRuleSetsResponse
  ) extends zio.aws.gamelift.model.DescribeMatchmakingRuleSetsResponse.ReadOnly {
    override val ruleSets
        : List[zio.aws.gamelift.model.MatchmakingRuleSet.ReadOnly] = impl
      .ruleSets()
      .asScala
      .map { item =>
        zio.aws.gamelift.model.MatchmakingRuleSet.wrap(item)
      }
      .toList
    override val nextToken: Option[NonZeroAndMaxString] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingRuleSetsResponse
  ): zio.aws.gamelift.model.DescribeMatchmakingRuleSetsResponse.ReadOnly =
    new Wrapper(impl)
}
