package zio.aws.gamelift.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.gamelift.model.primitives.{
  LocationStringModel,
  NonZeroAndMaxString,
  PositiveInteger,
  FleetIdOrArn
}
import scala.jdk.CollectionConverters._
final case class DescribeScalingPoliciesRequest(
    fleetId: FleetIdOrArn,
    statusFilter: Option[zio.aws.gamelift.model.ScalingStatusType] = None,
    limit: Option[PositiveInteger] = None,
    nextToken: Option[NonZeroAndMaxString] = None,
    location: Option[LocationStringModel] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.DescribeScalingPoliciesRequest = {
    import DescribeScalingPoliciesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.DescribeScalingPoliciesRequest
      .builder()
      .fleetId(FleetIdOrArn.unwrap(fleetId): java.lang.String)
      .optionallyWith(statusFilter.map(value => value.unwrap))(_.statusFilter)
      .optionallyWith(
        limit.map(value => PositiveInteger.unwrap(value): Integer)
      )(_.limit)
      .optionallyWith(
        nextToken.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .optionallyWith(
        location.map(value =>
          LocationStringModel.unwrap(value): java.lang.String
        )
      )(_.location)
      .build()
  }
  def asReadOnly
      : zio.aws.gamelift.model.DescribeScalingPoliciesRequest.ReadOnly =
    zio.aws.gamelift.model.DescribeScalingPoliciesRequest.wrap(buildAwsValue())
}
object DescribeScalingPoliciesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.DescribeScalingPoliciesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.DescribeScalingPoliciesRequest =
      zio.aws.gamelift.model.DescribeScalingPoliciesRequest(
        fleetId,
        statusFilter.map(value => value),
        limit.map(value => value),
        nextToken.map(value => value),
        location.map(value => value)
      )
    def fleetId: FleetIdOrArn
    def statusFilter: Option[zio.aws.gamelift.model.ScalingStatusType]
    def limit: Option[PositiveInteger]
    def nextToken: Option[NonZeroAndMaxString]
    def location: Option[LocationStringModel]
    def getFleetId: ZIO[Any, Nothing, FleetIdOrArn] = ZIO.succeed(fleetId)
    def getStatusFilter
        : ZIO[Any, AwsError, zio.aws.gamelift.model.ScalingStatusType] =
      AwsError.unwrapOptionField("statusFilter", statusFilter)
    def getLimit: ZIO[Any, AwsError, PositiveInteger] =
      AwsError.unwrapOptionField("limit", limit)
    def getNextToken: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getLocation: ZIO[Any, AwsError, LocationStringModel] =
      AwsError.unwrapOptionField("location", location)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeScalingPoliciesRequest
  ) extends zio.aws.gamelift.model.DescribeScalingPoliciesRequest.ReadOnly {
    override val fleetId: FleetIdOrArn =
      zio.aws.gamelift.model.primitives.FleetIdOrArn(impl.fleetId())
    override val statusFilter
        : Option[zio.aws.gamelift.model.ScalingStatusType] = scala
      .Option(impl.statusFilter())
      .map(value => zio.aws.gamelift.model.ScalingStatusType.wrap(value))
    override val limit: Option[PositiveInteger] = scala
      .Option(impl.limit())
      .map(value => zio.aws.gamelift.model.primitives.PositiveInteger(value))
    override val nextToken: Option[NonZeroAndMaxString] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
      )
    override val location: Option[LocationStringModel] = scala
      .Option(impl.location())
      .map(value =>
        zio.aws.gamelift.model.primitives.LocationStringModel(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeScalingPoliciesRequest
  ): zio.aws.gamelift.model.DescribeScalingPoliciesRequest.ReadOnly =
    new Wrapper(impl)
}
