package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.gamelift.model.primitives.NonZeroAndMaxString
import scala.jdk.CollectionConverters._
final case class DescribeScalingPoliciesResponse(
    scalingPolicies: Option[Iterable[zio.aws.gamelift.model.ScalingPolicy]] =
      None,
    nextToken: Option[NonZeroAndMaxString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.DescribeScalingPoliciesResponse = {
    import DescribeScalingPoliciesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.DescribeScalingPoliciesResponse
      .builder()
      .optionallyWith(
        scalingPolicies.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.scalingPolicies)
      .optionallyWith(
        nextToken.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.gamelift.model.DescribeScalingPoliciesResponse.ReadOnly =
    zio.aws.gamelift.model.DescribeScalingPoliciesResponse.wrap(buildAwsValue())
}
object DescribeScalingPoliciesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.DescribeScalingPoliciesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.DescribeScalingPoliciesResponse =
      zio.aws.gamelift.model.DescribeScalingPoliciesResponse(
        scalingPolicies.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def scalingPolicies
        : Option[List[zio.aws.gamelift.model.ScalingPolicy.ReadOnly]]
    def nextToken: Option[NonZeroAndMaxString]
    def getScalingPolicies: ZIO[Any, AwsError, List[
      zio.aws.gamelift.model.ScalingPolicy.ReadOnly
    ]] = AwsError.unwrapOptionField("scalingPolicies", scalingPolicies)
    def getNextToken: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeScalingPoliciesResponse
  ) extends zio.aws.gamelift.model.DescribeScalingPoliciesResponse.ReadOnly {
    override val scalingPolicies
        : Option[List[zio.aws.gamelift.model.ScalingPolicy.ReadOnly]] = scala
      .Option(impl.scalingPolicies())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.gamelift.model.ScalingPolicy.wrap(item)
        }.toList
      )
    override val nextToken: Option[NonZeroAndMaxString] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeScalingPoliciesResponse
  ): zio.aws.gamelift.model.DescribeScalingPoliciesResponse.ReadOnly =
    new Wrapper(impl)
}
