package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.gamelift.model.primitives.{PlayerData, NonZeroAndMaxString}
import scala.jdk.CollectionConverters._
final case class DesiredPlayerSession(
    playerId: Option[NonZeroAndMaxString] = None,
    playerData: Option[PlayerData] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.DesiredPlayerSession = {
    import DesiredPlayerSession.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.DesiredPlayerSession
      .builder()
      .optionallyWith(
        playerId.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.playerId)
      .optionallyWith(
        playerData.map(value => PlayerData.unwrap(value): java.lang.String)
      )(_.playerData)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.DesiredPlayerSession.ReadOnly =
    zio.aws.gamelift.model.DesiredPlayerSession.wrap(buildAwsValue())
}
object DesiredPlayerSession {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.DesiredPlayerSession
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.DesiredPlayerSession =
      zio.aws.gamelift.model.DesiredPlayerSession(
        playerId.map(value => value),
        playerData.map(value => value)
      )
    def playerId: Option[NonZeroAndMaxString]
    def playerData: Option[PlayerData]
    def getPlayerId: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("playerId", playerId)
    def getPlayerData: ZIO[Any, AwsError, PlayerData] =
      AwsError.unwrapOptionField("playerData", playerData)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.DesiredPlayerSession
  ) extends zio.aws.gamelift.model.DesiredPlayerSession.ReadOnly {
    override val playerId: Option[NonZeroAndMaxString] = scala
      .Option(impl.playerId())
      .map(value =>
        zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
      )
    override val playerData: Option[PlayerData] = scala
      .Option(impl.playerData())
      .map(value => zio.aws.gamelift.model.primitives.PlayerData(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.DesiredPlayerSession
  ): zio.aws.gamelift.model.DesiredPlayerSession.ReadOnly = new Wrapper(impl)
}
