package zio.aws.gamelift.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.gamelift.model.primitives.WholeNumber
import scala.jdk.CollectionConverters._
final case class EC2InstanceCounts(
    desired: Option[WholeNumber] = None,
    minimum: Option[WholeNumber] = None,
    maximum: Option[WholeNumber] = None,
    pending: Option[WholeNumber] = None,
    active: Option[WholeNumber] = None,
    idle: Option[WholeNumber] = None,
    terminating: Option[WholeNumber] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.EC2InstanceCounts = {
    import EC2InstanceCounts.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.EC2InstanceCounts
      .builder()
      .optionallyWith(desired.map(value => WholeNumber.unwrap(value): Integer))(
        _.desired
      )
      .optionallyWith(minimum.map(value => WholeNumber.unwrap(value): Integer))(
        _.minimum
      )
      .optionallyWith(maximum.map(value => WholeNumber.unwrap(value): Integer))(
        _.maximum
      )
      .optionallyWith(pending.map(value => WholeNumber.unwrap(value): Integer))(
        _.pending
      )
      .optionallyWith(active.map(value => WholeNumber.unwrap(value): Integer))(
        _.active
      )
      .optionallyWith(idle.map(value => WholeNumber.unwrap(value): Integer))(
        _.idle
      )
      .optionallyWith(
        terminating.map(value => WholeNumber.unwrap(value): Integer)
      )(_.terminating)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.EC2InstanceCounts.ReadOnly =
    zio.aws.gamelift.model.EC2InstanceCounts.wrap(buildAwsValue())
}
object EC2InstanceCounts {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.EC2InstanceCounts
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.EC2InstanceCounts =
      zio.aws.gamelift.model.EC2InstanceCounts(
        desired.map(value => value),
        minimum.map(value => value),
        maximum.map(value => value),
        pending.map(value => value),
        active.map(value => value),
        idle.map(value => value),
        terminating.map(value => value)
      )
    def desired: Option[WholeNumber]
    def minimum: Option[WholeNumber]
    def maximum: Option[WholeNumber]
    def pending: Option[WholeNumber]
    def active: Option[WholeNumber]
    def idle: Option[WholeNumber]
    def terminating: Option[WholeNumber]
    def getDesired: ZIO[Any, AwsError, WholeNumber] =
      AwsError.unwrapOptionField("desired", desired)
    def getMinimum: ZIO[Any, AwsError, WholeNumber] =
      AwsError.unwrapOptionField("minimum", minimum)
    def getMaximum: ZIO[Any, AwsError, WholeNumber] =
      AwsError.unwrapOptionField("maximum", maximum)
    def getPending: ZIO[Any, AwsError, WholeNumber] =
      AwsError.unwrapOptionField("pending", pending)
    def getActive: ZIO[Any, AwsError, WholeNumber] =
      AwsError.unwrapOptionField("active", active)
    def getIdle: ZIO[Any, AwsError, WholeNumber] =
      AwsError.unwrapOptionField("idle", idle)
    def getTerminating: ZIO[Any, AwsError, WholeNumber] =
      AwsError.unwrapOptionField("terminating", terminating)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.EC2InstanceCounts
  ) extends zio.aws.gamelift.model.EC2InstanceCounts.ReadOnly {
    override val desired: Option[WholeNumber] = scala
      .Option(impl.desired())
      .map(value => zio.aws.gamelift.model.primitives.WholeNumber(value))
    override val minimum: Option[WholeNumber] = scala
      .Option(impl.minimum())
      .map(value => zio.aws.gamelift.model.primitives.WholeNumber(value))
    override val maximum: Option[WholeNumber] = scala
      .Option(impl.maximum())
      .map(value => zio.aws.gamelift.model.primitives.WholeNumber(value))
    override val pending: Option[WholeNumber] = scala
      .Option(impl.pending())
      .map(value => zio.aws.gamelift.model.primitives.WholeNumber(value))
    override val active: Option[WholeNumber] = scala
      .Option(impl.active())
      .map(value => zio.aws.gamelift.model.primitives.WholeNumber(value))
    override val idle: Option[WholeNumber] = scala
      .Option(impl.idle())
      .map(value => zio.aws.gamelift.model.primitives.WholeNumber(value))
    override val terminating: Option[WholeNumber] = scala
      .Option(impl.terminating())
      .map(value => zio.aws.gamelift.model.primitives.WholeNumber(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.EC2InstanceCounts
  ): zio.aws.gamelift.model.EC2InstanceCounts.ReadOnly = new Wrapper(impl)
}
