package zio.aws.gamelift.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.gamelift.model.primitives.{LocationStringModel, WholeNumber}
import scala.jdk.CollectionConverters._
final case class EC2InstanceLimit(
    ec2InstanceType: Option[zio.aws.gamelift.model.EC2InstanceType] = None,
    currentInstances: Option[WholeNumber] = None,
    instanceLimit: Option[WholeNumber] = None,
    location: Option[LocationStringModel] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.EC2InstanceLimit = {
    import EC2InstanceLimit.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.EC2InstanceLimit
      .builder()
      .optionallyWith(ec2InstanceType.map(value => value.unwrap))(
        _.ec2InstanceType
      )
      .optionallyWith(
        currentInstances.map(value => WholeNumber.unwrap(value): Integer)
      )(_.currentInstances)
      .optionallyWith(
        instanceLimit.map(value => WholeNumber.unwrap(value): Integer)
      )(_.instanceLimit)
      .optionallyWith(
        location.map(value =>
          LocationStringModel.unwrap(value): java.lang.String
        )
      )(_.location)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.EC2InstanceLimit.ReadOnly =
    zio.aws.gamelift.model.EC2InstanceLimit.wrap(buildAwsValue())
}
object EC2InstanceLimit {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.EC2InstanceLimit
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.EC2InstanceLimit =
      zio.aws.gamelift.model.EC2InstanceLimit(
        ec2InstanceType.map(value => value),
        currentInstances.map(value => value),
        instanceLimit.map(value => value),
        location.map(value => value)
      )
    def ec2InstanceType: Option[zio.aws.gamelift.model.EC2InstanceType]
    def currentInstances: Option[WholeNumber]
    def instanceLimit: Option[WholeNumber]
    def location: Option[LocationStringModel]
    def getEc2InstanceType
        : ZIO[Any, AwsError, zio.aws.gamelift.model.EC2InstanceType] =
      AwsError.unwrapOptionField("ec2InstanceType", ec2InstanceType)
    def getCurrentInstances: ZIO[Any, AwsError, WholeNumber] =
      AwsError.unwrapOptionField("currentInstances", currentInstances)
    def getInstanceLimit: ZIO[Any, AwsError, WholeNumber] =
      AwsError.unwrapOptionField("instanceLimit", instanceLimit)
    def getLocation: ZIO[Any, AwsError, LocationStringModel] =
      AwsError.unwrapOptionField("location", location)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.EC2InstanceLimit
  ) extends zio.aws.gamelift.model.EC2InstanceLimit.ReadOnly {
    override val ec2InstanceType
        : Option[zio.aws.gamelift.model.EC2InstanceType] = scala
      .Option(impl.ec2InstanceType())
      .map(value => zio.aws.gamelift.model.EC2InstanceType.wrap(value))
    override val currentInstances: Option[WholeNumber] = scala
      .Option(impl.currentInstances())
      .map(value => zio.aws.gamelift.model.primitives.WholeNumber(value))
    override val instanceLimit: Option[WholeNumber] = scala
      .Option(impl.instanceLimit())
      .map(value => zio.aws.gamelift.model.primitives.WholeNumber(value))
    override val location: Option[LocationStringModel] = scala
      .Option(impl.location())
      .map(value =>
        zio.aws.gamelift.model.primitives.LocationStringModel(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.EC2InstanceLimit
  ): zio.aws.gamelift.model.EC2InstanceLimit.ReadOnly = new Wrapper(impl)
}
