package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.gamelift.model.primitives.{
  Timestamp,
  NonEmptyString,
  NonZeroAndMaxString
}
import scala.jdk.CollectionConverters._
final case class Event(
    eventId: Option[NonZeroAndMaxString] = None,
    resourceId: Option[NonZeroAndMaxString] = None,
    eventCode: Option[zio.aws.gamelift.model.EventCode] = None,
    message: Option[NonEmptyString] = None,
    eventTime: Option[Timestamp] = None,
    preSignedLogUrl: Option[NonZeroAndMaxString] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.gamelift.model.Event = {
    import Event.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.Event
      .builder()
      .optionallyWith(
        eventId.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.eventId)
      .optionallyWith(
        resourceId.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.resourceId)
      .optionallyWith(eventCode.map(value => value.unwrap))(_.eventCode)
      .optionallyWith(
        message.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.message)
      .optionallyWith(eventTime.map(value => Timestamp.unwrap(value): Instant))(
        _.eventTime
      )
      .optionallyWith(
        preSignedLogUrl.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.preSignedLogUrl)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.Event.ReadOnly =
    zio.aws.gamelift.model.Event.wrap(buildAwsValue())
}
object Event {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.gamelift.model.Event] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.Event = zio.aws.gamelift.model.Event(
      eventId.map(value => value),
      resourceId.map(value => value),
      eventCode.map(value => value),
      message.map(value => value),
      eventTime.map(value => value),
      preSignedLogUrl.map(value => value)
    )
    def eventId: Option[NonZeroAndMaxString]
    def resourceId: Option[NonZeroAndMaxString]
    def eventCode: Option[zio.aws.gamelift.model.EventCode]
    def message: Option[NonEmptyString]
    def eventTime: Option[Timestamp]
    def preSignedLogUrl: Option[NonZeroAndMaxString]
    def getEventId: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("eventId", eventId)
    def getResourceId: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("resourceId", resourceId)
    def getEventCode: ZIO[Any, AwsError, zio.aws.gamelift.model.EventCode] =
      AwsError.unwrapOptionField("eventCode", eventCode)
    def getMessage: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("message", message)
    def getEventTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("eventTime", eventTime)
    def getPreSignedLogUrl: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("preSignedLogUrl", preSignedLogUrl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.Event
  ) extends zio.aws.gamelift.model.Event.ReadOnly {
    override val eventId: Option[NonZeroAndMaxString] = scala
      .Option(impl.eventId())
      .map(value =>
        zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
      )
    override val resourceId: Option[NonZeroAndMaxString] = scala
      .Option(impl.resourceId())
      .map(value =>
        zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
      )
    override val eventCode: Option[zio.aws.gamelift.model.EventCode] = scala
      .Option(impl.eventCode())
      .map(value => zio.aws.gamelift.model.EventCode.wrap(value))
    override val message: Option[NonEmptyString] = scala
      .Option(impl.message())
      .map(value => zio.aws.gamelift.model.primitives.NonEmptyString(value))
    override val eventTime: Option[Timestamp] = scala
      .Option(impl.eventTime())
      .map(value => zio.aws.gamelift.model.primitives.Timestamp(value))
    override val preSignedLogUrl: Option[NonZeroAndMaxString] = scala
      .Option(impl.preSignedLogUrl())
      .map(value =>
        zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.Event
  ): zio.aws.gamelift.model.Event.ReadOnly = new Wrapper(impl)
}
