package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.gamelift.model.primitives.LocationStringModel
import scala.jdk.CollectionConverters._
final case class FilterConfiguration(
    allowedLocations: Option[Iterable[LocationStringModel]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.FilterConfiguration = {
    import FilterConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.FilterConfiguration
      .builder()
      .optionallyWith(
        allowedLocations.map(value =>
          value.map { item =>
            LocationStringModel.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.allowedLocations)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.FilterConfiguration.ReadOnly =
    zio.aws.gamelift.model.FilterConfiguration.wrap(buildAwsValue())
}
object FilterConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.FilterConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.FilterConfiguration =
      zio.aws.gamelift.model
        .FilterConfiguration(allowedLocations.map(value => value))
    def allowedLocations: Option[List[LocationStringModel]]
    def getAllowedLocations: ZIO[Any, AwsError, List[LocationStringModel]] =
      AwsError.unwrapOptionField("allowedLocations", allowedLocations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.FilterConfiguration
  ) extends zio.aws.gamelift.model.FilterConfiguration.ReadOnly {
    override val allowedLocations: Option[List[LocationStringModel]] = scala
      .Option(impl.allowedLocations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.gamelift.model.primitives.LocationStringModel(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.FilterConfiguration
  ): zio.aws.gamelift.model.FilterConfiguration.ReadOnly = new Wrapper(impl)
}
