package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.gamelift.model.primitives.{
  FleetId,
  FleetArn,
  Timestamp,
  ScriptId,
  ScriptArn,
  BuildArn,
  LaunchParametersStringModel,
  BuildId,
  MetricGroup,
  NonZeroAndMaxString,
  LaunchPathStringModel,
  NonEmptyString
}
import scala.jdk.CollectionConverters._
final case class FleetAttributes(
    fleetId: Option[FleetId] = None,
    fleetArn: Option[FleetArn] = None,
    fleetType: Option[zio.aws.gamelift.model.FleetType] = None,
    instanceType: Option[zio.aws.gamelift.model.EC2InstanceType] = None,
    description: Option[NonZeroAndMaxString] = None,
    name: Option[NonZeroAndMaxString] = None,
    creationTime: Option[Timestamp] = None,
    terminationTime: Option[Timestamp] = None,
    status: Option[zio.aws.gamelift.model.FleetStatus] = None,
    buildId: Option[BuildId] = None,
    buildArn: Option[BuildArn] = None,
    scriptId: Option[ScriptId] = None,
    scriptArn: Option[ScriptArn] = None,
    serverLaunchPath: Option[LaunchPathStringModel] = None,
    serverLaunchParameters: Option[LaunchParametersStringModel] = None,
    logPaths: Option[Iterable[NonZeroAndMaxString]] = None,
    newGameSessionProtectionPolicy: Option[
      zio.aws.gamelift.model.ProtectionPolicy
    ] = None,
    operatingSystem: Option[zio.aws.gamelift.model.OperatingSystem] = None,
    resourceCreationLimitPolicy: Option[
      zio.aws.gamelift.model.ResourceCreationLimitPolicy
    ] = None,
    metricGroups: Option[Iterable[MetricGroup]] = None,
    stoppedActions: Option[Iterable[zio.aws.gamelift.model.FleetAction]] = None,
    instanceRoleArn: Option[NonEmptyString] = None,
    certificateConfiguration: Option[
      zio.aws.gamelift.model.CertificateConfiguration
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.FleetAttributes = {
    import FleetAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.FleetAttributes
      .builder()
      .optionallyWith(
        fleetId.map(value => FleetId.unwrap(value): java.lang.String)
      )(_.fleetId)
      .optionallyWith(
        fleetArn.map(value => FleetArn.unwrap(value): java.lang.String)
      )(_.fleetArn)
      .optionallyWith(fleetType.map(value => value.unwrap))(_.fleetType)
      .optionallyWith(instanceType.map(value => value.unwrap))(_.instanceType)
      .optionallyWith(
        description.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        name.map(value => NonZeroAndMaxString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        terminationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.terminationTime)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        buildId.map(value => BuildId.unwrap(value): java.lang.String)
      )(_.buildId)
      .optionallyWith(
        buildArn.map(value => BuildArn.unwrap(value): java.lang.String)
      )(_.buildArn)
      .optionallyWith(
        scriptId.map(value => ScriptId.unwrap(value): java.lang.String)
      )(_.scriptId)
      .optionallyWith(
        scriptArn.map(value => ScriptArn.unwrap(value): java.lang.String)
      )(_.scriptArn)
      .optionallyWith(
        serverLaunchPath.map(value =>
          LaunchPathStringModel.unwrap(value): java.lang.String
        )
      )(_.serverLaunchPath)
      .optionallyWith(
        serverLaunchParameters.map(value =>
          LaunchParametersStringModel.unwrap(value): java.lang.String
        )
      )(_.serverLaunchParameters)
      .optionallyWith(
        logPaths.map(value =>
          value.map { item =>
            NonZeroAndMaxString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.logPaths)
      .optionallyWith(
        newGameSessionProtectionPolicy.map(value => value.unwrap)
      )(_.newGameSessionProtectionPolicy)
      .optionallyWith(operatingSystem.map(value => value.unwrap))(
        _.operatingSystem
      )
      .optionallyWith(
        resourceCreationLimitPolicy.map(value => value.buildAwsValue())
      )(_.resourceCreationLimitPolicy)
      .optionallyWith(
        metricGroups.map(value =>
          value.map { item =>
            MetricGroup.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.metricGroups)
      .optionallyWith(
        stoppedActions.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.stoppedActionsWithStrings)
      .optionallyWith(
        instanceRoleArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.instanceRoleArn)
      .optionallyWith(
        certificateConfiguration.map(value => value.buildAwsValue())
      )(_.certificateConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.FleetAttributes.ReadOnly =
    zio.aws.gamelift.model.FleetAttributes.wrap(buildAwsValue())
}
object FleetAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.FleetAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.FleetAttributes =
      zio.aws.gamelift.model.FleetAttributes(
        fleetId.map(value => value),
        fleetArn.map(value => value),
        fleetType.map(value => value),
        instanceType.map(value => value),
        description.map(value => value),
        name.map(value => value),
        creationTime.map(value => value),
        terminationTime.map(value => value),
        status.map(value => value),
        buildId.map(value => value),
        buildArn.map(value => value),
        scriptId.map(value => value),
        scriptArn.map(value => value),
        serverLaunchPath.map(value => value),
        serverLaunchParameters.map(value => value),
        logPaths.map(value => value),
        newGameSessionProtectionPolicy.map(value => value),
        operatingSystem.map(value => value),
        resourceCreationLimitPolicy.map(value => value.asEditable),
        metricGroups.map(value => value),
        stoppedActions.map(value => value),
        instanceRoleArn.map(value => value),
        certificateConfiguration.map(value => value.asEditable)
      )
    def fleetId: Option[FleetId]
    def fleetArn: Option[FleetArn]
    def fleetType: Option[zio.aws.gamelift.model.FleetType]
    def instanceType: Option[zio.aws.gamelift.model.EC2InstanceType]
    def description: Option[NonZeroAndMaxString]
    def name: Option[NonZeroAndMaxString]
    def creationTime: Option[Timestamp]
    def terminationTime: Option[Timestamp]
    def status: Option[zio.aws.gamelift.model.FleetStatus]
    def buildId: Option[BuildId]
    def buildArn: Option[BuildArn]
    def scriptId: Option[ScriptId]
    def scriptArn: Option[ScriptArn]
    def serverLaunchPath: Option[LaunchPathStringModel]
    def serverLaunchParameters: Option[LaunchParametersStringModel]
    def logPaths: Option[List[NonZeroAndMaxString]]
    def newGameSessionProtectionPolicy
        : Option[zio.aws.gamelift.model.ProtectionPolicy]
    def operatingSystem: Option[zio.aws.gamelift.model.OperatingSystem]
    def resourceCreationLimitPolicy
        : Option[zio.aws.gamelift.model.ResourceCreationLimitPolicy.ReadOnly]
    def metricGroups: Option[List[MetricGroup]]
    def stoppedActions: Option[List[zio.aws.gamelift.model.FleetAction]]
    def instanceRoleArn: Option[NonEmptyString]
    def certificateConfiguration
        : Option[zio.aws.gamelift.model.CertificateConfiguration.ReadOnly]
    def getFleetId: ZIO[Any, AwsError, FleetId] =
      AwsError.unwrapOptionField("fleetId", fleetId)
    def getFleetArn: ZIO[Any, AwsError, FleetArn] =
      AwsError.unwrapOptionField("fleetArn", fleetArn)
    def getFleetType: ZIO[Any, AwsError, zio.aws.gamelift.model.FleetType] =
      AwsError.unwrapOptionField("fleetType", fleetType)
    def getInstanceType
        : ZIO[Any, AwsError, zio.aws.gamelift.model.EC2InstanceType] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getDescription: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("description", description)
    def getName: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("name", name)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getTerminationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("terminationTime", terminationTime)
    def getStatus: ZIO[Any, AwsError, zio.aws.gamelift.model.FleetStatus] =
      AwsError.unwrapOptionField("status", status)
    def getBuildId: ZIO[Any, AwsError, BuildId] =
      AwsError.unwrapOptionField("buildId", buildId)
    def getBuildArn: ZIO[Any, AwsError, BuildArn] =
      AwsError.unwrapOptionField("buildArn", buildArn)
    def getScriptId: ZIO[Any, AwsError, ScriptId] =
      AwsError.unwrapOptionField("scriptId", scriptId)
    def getScriptArn: ZIO[Any, AwsError, ScriptArn] =
      AwsError.unwrapOptionField("scriptArn", scriptArn)
    def getServerLaunchPath: ZIO[Any, AwsError, LaunchPathStringModel] =
      AwsError.unwrapOptionField("serverLaunchPath", serverLaunchPath)
    def getServerLaunchParameters
        : ZIO[Any, AwsError, LaunchParametersStringModel] = AwsError
      .unwrapOptionField("serverLaunchParameters", serverLaunchParameters)
    def getLogPaths: ZIO[Any, AwsError, List[NonZeroAndMaxString]] =
      AwsError.unwrapOptionField("logPaths", logPaths)
    def getNewGameSessionProtectionPolicy
        : ZIO[Any, AwsError, zio.aws.gamelift.model.ProtectionPolicy] =
      AwsError.unwrapOptionField(
        "newGameSessionProtectionPolicy",
        newGameSessionProtectionPolicy
      )
    def getOperatingSystem
        : ZIO[Any, AwsError, zio.aws.gamelift.model.OperatingSystem] =
      AwsError.unwrapOptionField("operatingSystem", operatingSystem)
    def getResourceCreationLimitPolicy: ZIO[
      Any,
      AwsError,
      zio.aws.gamelift.model.ResourceCreationLimitPolicy.ReadOnly
    ] = AwsError.unwrapOptionField(
      "resourceCreationLimitPolicy",
      resourceCreationLimitPolicy
    )
    def getMetricGroups: ZIO[Any, AwsError, List[MetricGroup]] =
      AwsError.unwrapOptionField("metricGroups", metricGroups)
    def getStoppedActions
        : ZIO[Any, AwsError, List[zio.aws.gamelift.model.FleetAction]] =
      AwsError.unwrapOptionField("stoppedActions", stoppedActions)
    def getInstanceRoleArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("instanceRoleArn", instanceRoleArn)
    def getCertificateConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.gamelift.model.CertificateConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "certificateConfiguration",
      certificateConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.FleetAttributes
  ) extends zio.aws.gamelift.model.FleetAttributes.ReadOnly {
    override val fleetId: Option[FleetId] = scala
      .Option(impl.fleetId())
      .map(value => zio.aws.gamelift.model.primitives.FleetId(value))
    override val fleetArn: Option[FleetArn] = scala
      .Option(impl.fleetArn())
      .map(value => zio.aws.gamelift.model.primitives.FleetArn(value))
    override val fleetType: Option[zio.aws.gamelift.model.FleetType] = scala
      .Option(impl.fleetType())
      .map(value => zio.aws.gamelift.model.FleetType.wrap(value))
    override val instanceType: Option[zio.aws.gamelift.model.EC2InstanceType] =
      scala
        .Option(impl.instanceType())
        .map(value => zio.aws.gamelift.model.EC2InstanceType.wrap(value))
    override val description: Option[NonZeroAndMaxString] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
      )
    override val name: Option[NonZeroAndMaxString] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
      )
    override val creationTime: Option[Timestamp] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.gamelift.model.primitives.Timestamp(value))
    override val terminationTime: Option[Timestamp] = scala
      .Option(impl.terminationTime())
      .map(value => zio.aws.gamelift.model.primitives.Timestamp(value))
    override val status: Option[zio.aws.gamelift.model.FleetStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.gamelift.model.FleetStatus.wrap(value))
    override val buildId: Option[BuildId] = scala
      .Option(impl.buildId())
      .map(value => zio.aws.gamelift.model.primitives.BuildId(value))
    override val buildArn: Option[BuildArn] = scala
      .Option(impl.buildArn())
      .map(value => zio.aws.gamelift.model.primitives.BuildArn(value))
    override val scriptId: Option[ScriptId] = scala
      .Option(impl.scriptId())
      .map(value => zio.aws.gamelift.model.primitives.ScriptId(value))
    override val scriptArn: Option[ScriptArn] = scala
      .Option(impl.scriptArn())
      .map(value => zio.aws.gamelift.model.primitives.ScriptArn(value))
    override val serverLaunchPath: Option[LaunchPathStringModel] = scala
      .Option(impl.serverLaunchPath())
      .map(value =>
        zio.aws.gamelift.model.primitives.LaunchPathStringModel(value)
      )
    override val serverLaunchParameters: Option[LaunchParametersStringModel] =
      scala
        .Option(impl.serverLaunchParameters())
        .map(value =>
          zio.aws.gamelift.model.primitives.LaunchParametersStringModel(value)
        )
    override val logPaths: Option[List[NonZeroAndMaxString]] = scala
      .Option(impl.logPaths())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.gamelift.model.primitives.NonZeroAndMaxString(item)
        }.toList
      )
    override val newGameSessionProtectionPolicy
        : Option[zio.aws.gamelift.model.ProtectionPolicy] = scala
      .Option(impl.newGameSessionProtectionPolicy())
      .map(value => zio.aws.gamelift.model.ProtectionPolicy.wrap(value))
    override val operatingSystem
        : Option[zio.aws.gamelift.model.OperatingSystem] = scala
      .Option(impl.operatingSystem())
      .map(value => zio.aws.gamelift.model.OperatingSystem.wrap(value))
    override val resourceCreationLimitPolicy
        : Option[zio.aws.gamelift.model.ResourceCreationLimitPolicy.ReadOnly] =
      scala
        .Option(impl.resourceCreationLimitPolicy())
        .map(value =>
          zio.aws.gamelift.model.ResourceCreationLimitPolicy.wrap(value)
        )
    override val metricGroups: Option[List[MetricGroup]] = scala
      .Option(impl.metricGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.gamelift.model.primitives.MetricGroup(item)
        }.toList
      )
    override val stoppedActions
        : Option[List[zio.aws.gamelift.model.FleetAction]] = scala
      .Option(impl.stoppedActions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.gamelift.model.FleetAction.wrap(item)
        }.toList
      )
    override val instanceRoleArn: Option[NonEmptyString] = scala
      .Option(impl.instanceRoleArn())
      .map(value => zio.aws.gamelift.model.primitives.NonEmptyString(value))
    override val certificateConfiguration
        : Option[zio.aws.gamelift.model.CertificateConfiguration.ReadOnly] =
      scala
        .Option(impl.certificateConfiguration())
        .map(value =>
          zio.aws.gamelift.model.CertificateConfiguration.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.FleetAttributes
  ): zio.aws.gamelift.model.FleetAttributes.ReadOnly = new Wrapper(impl)
}
