package zio.aws.gamelift.model
import scala.jdk.CollectionConverters._
sealed trait FleetType {
  def unwrap: software.amazon.awssdk.services.gamelift.model.FleetType
}
object FleetType {
  def wrap(
      value: software.amazon.awssdk.services.gamelift.model.FleetType
  ): zio.aws.gamelift.model.FleetType = value match {
    case software.amazon.awssdk.services.gamelift.model.FleetType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.gamelift.model.FleetType.ON_DEMAND =>
      val r = ON_DEMAND
      r
    case software.amazon.awssdk.services.gamelift.model.FleetType.SPOT =>
      val r = SPOT
      r
  }
  case object unknownToSdkVersion extends zio.aws.gamelift.model.FleetType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.FleetType =
      software.amazon.awssdk.services.gamelift.model.FleetType.UNKNOWN_TO_SDK_VERSION
  }
  case object ON_DEMAND extends zio.aws.gamelift.model.FleetType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.FleetType =
      software.amazon.awssdk.services.gamelift.model.FleetType.ON_DEMAND
  }
  case object SPOT extends zio.aws.gamelift.model.FleetType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.FleetType =
      software.amazon.awssdk.services.gamelift.model.FleetType.SPOT
  }
}
