package zio.aws.gamelift.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.gamelift.model.primitives.{
  LocationStringModel,
  WholeNumber,
  FleetArn,
  FleetId
}
import scala.jdk.CollectionConverters._
final case class FleetUtilization(
    fleetId: Option[FleetId] = None,
    fleetArn: Option[FleetArn] = None,
    activeServerProcessCount: Option[WholeNumber] = None,
    activeGameSessionCount: Option[WholeNumber] = None,
    currentPlayerSessionCount: Option[WholeNumber] = None,
    maximumPlayerSessionCount: Option[WholeNumber] = None,
    location: Option[LocationStringModel] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.FleetUtilization = {
    import FleetUtilization.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.FleetUtilization
      .builder()
      .optionallyWith(
        fleetId.map(value => FleetId.unwrap(value): java.lang.String)
      )(_.fleetId)
      .optionallyWith(
        fleetArn.map(value => FleetArn.unwrap(value): java.lang.String)
      )(_.fleetArn)
      .optionallyWith(
        activeServerProcessCount.map(value =>
          WholeNumber.unwrap(value): Integer
        )
      )(_.activeServerProcessCount)
      .optionallyWith(
        activeGameSessionCount.map(value => WholeNumber.unwrap(value): Integer)
      )(_.activeGameSessionCount)
      .optionallyWith(
        currentPlayerSessionCount.map(value =>
          WholeNumber.unwrap(value): Integer
        )
      )(_.currentPlayerSessionCount)
      .optionallyWith(
        maximumPlayerSessionCount.map(value =>
          WholeNumber.unwrap(value): Integer
        )
      )(_.maximumPlayerSessionCount)
      .optionallyWith(
        location.map(value =>
          LocationStringModel.unwrap(value): java.lang.String
        )
      )(_.location)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.FleetUtilization.ReadOnly =
    zio.aws.gamelift.model.FleetUtilization.wrap(buildAwsValue())
}
object FleetUtilization {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.FleetUtilization
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.FleetUtilization =
      zio.aws.gamelift.model.FleetUtilization(
        fleetId.map(value => value),
        fleetArn.map(value => value),
        activeServerProcessCount.map(value => value),
        activeGameSessionCount.map(value => value),
        currentPlayerSessionCount.map(value => value),
        maximumPlayerSessionCount.map(value => value),
        location.map(value => value)
      )
    def fleetId: Option[FleetId]
    def fleetArn: Option[FleetArn]
    def activeServerProcessCount: Option[WholeNumber]
    def activeGameSessionCount: Option[WholeNumber]
    def currentPlayerSessionCount: Option[WholeNumber]
    def maximumPlayerSessionCount: Option[WholeNumber]
    def location: Option[LocationStringModel]
    def getFleetId: ZIO[Any, AwsError, FleetId] =
      AwsError.unwrapOptionField("fleetId", fleetId)
    def getFleetArn: ZIO[Any, AwsError, FleetArn] =
      AwsError.unwrapOptionField("fleetArn", fleetArn)
    def getActiveServerProcessCount: ZIO[Any, AwsError, WholeNumber] = AwsError
      .unwrapOptionField("activeServerProcessCount", activeServerProcessCount)
    def getActiveGameSessionCount: ZIO[Any, AwsError, WholeNumber] = AwsError
      .unwrapOptionField("activeGameSessionCount", activeGameSessionCount)
    def getCurrentPlayerSessionCount: ZIO[Any, AwsError, WholeNumber] = AwsError
      .unwrapOptionField("currentPlayerSessionCount", currentPlayerSessionCount)
    def getMaximumPlayerSessionCount: ZIO[Any, AwsError, WholeNumber] = AwsError
      .unwrapOptionField("maximumPlayerSessionCount", maximumPlayerSessionCount)
    def getLocation: ZIO[Any, AwsError, LocationStringModel] =
      AwsError.unwrapOptionField("location", location)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.FleetUtilization
  ) extends zio.aws.gamelift.model.FleetUtilization.ReadOnly {
    override val fleetId: Option[FleetId] = scala
      .Option(impl.fleetId())
      .map(value => zio.aws.gamelift.model.primitives.FleetId(value))
    override val fleetArn: Option[FleetArn] = scala
      .Option(impl.fleetArn())
      .map(value => zio.aws.gamelift.model.primitives.FleetArn(value))
    override val activeServerProcessCount: Option[WholeNumber] = scala
      .Option(impl.activeServerProcessCount())
      .map(value => zio.aws.gamelift.model.primitives.WholeNumber(value))
    override val activeGameSessionCount: Option[WholeNumber] = scala
      .Option(impl.activeGameSessionCount())
      .map(value => zio.aws.gamelift.model.primitives.WholeNumber(value))
    override val currentPlayerSessionCount: Option[WholeNumber] = scala
      .Option(impl.currentPlayerSessionCount())
      .map(value => zio.aws.gamelift.model.primitives.WholeNumber(value))
    override val maximumPlayerSessionCount: Option[WholeNumber] = scala
      .Option(impl.maximumPlayerSessionCount())
      .map(value => zio.aws.gamelift.model.primitives.WholeNumber(value))
    override val location: Option[LocationStringModel] = scala
      .Option(impl.location())
      .map(value =>
        zio.aws.gamelift.model.primitives.LocationStringModel(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.FleetUtilization
  ): zio.aws.gamelift.model.FleetUtilization.ReadOnly = new Wrapper(impl)
}
