package zio.aws.gamelift.model
import scala.jdk.CollectionConverters._
sealed trait FlexMatchMode {
  def unwrap: software.amazon.awssdk.services.gamelift.model.FlexMatchMode
}
object FlexMatchMode {
  def wrap(
      value: software.amazon.awssdk.services.gamelift.model.FlexMatchMode
  ): zio.aws.gamelift.model.FlexMatchMode = value match {
    case software.amazon.awssdk.services.gamelift.model.FlexMatchMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.gamelift.model.FlexMatchMode.STANDALONE =>
      val r = STANDALONE
      r
    case software.amazon.awssdk.services.gamelift.model.FlexMatchMode.WITH_QUEUE =>
      val r = WITH_QUEUE
      r
  }
  case object unknownToSdkVersion extends zio.aws.gamelift.model.FlexMatchMode {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.FlexMatchMode =
      software.amazon.awssdk.services.gamelift.model.FlexMatchMode.UNKNOWN_TO_SDK_VERSION
  }
  case object STANDALONE extends zio.aws.gamelift.model.FlexMatchMode {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.FlexMatchMode =
      software.amazon.awssdk.services.gamelift.model.FlexMatchMode.STANDALONE
  }
  case object WITH_QUEUE extends zio.aws.gamelift.model.FlexMatchMode {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.FlexMatchMode =
      software.amazon.awssdk.services.gamelift.model.FlexMatchMode.WITH_QUEUE
  }
}
