package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.gamelift.model.primitives.{GamePropertyValue, GamePropertyKey}
import scala.jdk.CollectionConverters._
final case class GameProperty(key: GamePropertyKey, value: GamePropertyValue) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.GameProperty = {
    import GameProperty.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.GameProperty
      .builder()
      .key(GamePropertyKey.unwrap(key): java.lang.String)
      .value(GamePropertyValue.unwrap(value): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.GameProperty.ReadOnly =
    zio.aws.gamelift.model.GameProperty.wrap(buildAwsValue())
}
object GameProperty {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.GameProperty
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.GameProperty =
      zio.aws.gamelift.model.GameProperty(key, value)
    def key: GamePropertyKey
    def value: GamePropertyValue
    def getKey: ZIO[Any, Nothing, GamePropertyKey] = ZIO.succeed(key)
    def getValue: ZIO[Any, Nothing, GamePropertyValue] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.GameProperty
  ) extends zio.aws.gamelift.model.GameProperty.ReadOnly {
    override val key: GamePropertyKey =
      zio.aws.gamelift.model.primitives.GamePropertyKey(impl.key())
    override val value: GamePropertyValue =
      zio.aws.gamelift.model.primitives.GamePropertyValue(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.GameProperty
  ): zio.aws.gamelift.model.GameProperty.ReadOnly = new Wrapper(impl)
}
