package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.gamelift.model.primitives.{
  IamRoleArn,
  AutoScalingGroupArn,
  GameServerGroupArn,
  Timestamp,
  GameServerGroupName,
  NonZeroAndMaxString
}
import scala.jdk.CollectionConverters._
final case class GameServerGroup(
    gameServerGroupName: Option[GameServerGroupName] = None,
    gameServerGroupArn: Option[GameServerGroupArn] = None,
    roleArn: Option[IamRoleArn] = None,
    instanceDefinitions: Option[
      Iterable[zio.aws.gamelift.model.InstanceDefinition]
    ] = None,
    balancingStrategy: Option[zio.aws.gamelift.model.BalancingStrategy] = None,
    gameServerProtectionPolicy: Option[
      zio.aws.gamelift.model.GameServerProtectionPolicy
    ] = None,
    autoScalingGroupArn: Option[AutoScalingGroupArn] = None,
    status: Option[zio.aws.gamelift.model.GameServerGroupStatus] = None,
    statusReason: Option[NonZeroAndMaxString] = None,
    suspendedActions: Option[
      Iterable[zio.aws.gamelift.model.GameServerGroupAction]
    ] = None,
    creationTime: Option[Timestamp] = None,
    lastUpdatedTime: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.GameServerGroup = {
    import GameServerGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.GameServerGroup
      .builder()
      .optionallyWith(
        gameServerGroupName.map(value =>
          GameServerGroupName.unwrap(value): java.lang.String
        )
      )(_.gameServerGroupName)
      .optionallyWith(
        gameServerGroupArn.map(value =>
          GameServerGroupArn.unwrap(value): java.lang.String
        )
      )(_.gameServerGroupArn)
      .optionallyWith(
        roleArn.map(value => IamRoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(
        instanceDefinitions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.instanceDefinitions)
      .optionallyWith(balancingStrategy.map(value => value.unwrap))(
        _.balancingStrategy
      )
      .optionallyWith(gameServerProtectionPolicy.map(value => value.unwrap))(
        _.gameServerProtectionPolicy
      )
      .optionallyWith(
        autoScalingGroupArn.map(value =>
          AutoScalingGroupArn.unwrap(value): java.lang.String
        )
      )(_.autoScalingGroupArn)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        statusReason.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.statusReason)
      .optionallyWith(
        suspendedActions.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.suspendedActionsWithStrings)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastUpdatedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedTime)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.GameServerGroup.ReadOnly =
    zio.aws.gamelift.model.GameServerGroup.wrap(buildAwsValue())
}
object GameServerGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.GameServerGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.GameServerGroup =
      zio.aws.gamelift.model.GameServerGroup(
        gameServerGroupName.map(value => value),
        gameServerGroupArn.map(value => value),
        roleArn.map(value => value),
        instanceDefinitions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        balancingStrategy.map(value => value),
        gameServerProtectionPolicy.map(value => value),
        autoScalingGroupArn.map(value => value),
        status.map(value => value),
        statusReason.map(value => value),
        suspendedActions.map(value => value),
        creationTime.map(value => value),
        lastUpdatedTime.map(value => value)
      )
    def gameServerGroupName: Option[GameServerGroupName]
    def gameServerGroupArn: Option[GameServerGroupArn]
    def roleArn: Option[IamRoleArn]
    def instanceDefinitions
        : Option[List[zio.aws.gamelift.model.InstanceDefinition.ReadOnly]]
    def balancingStrategy: Option[zio.aws.gamelift.model.BalancingStrategy]
    def gameServerProtectionPolicy
        : Option[zio.aws.gamelift.model.GameServerProtectionPolicy]
    def autoScalingGroupArn: Option[AutoScalingGroupArn]
    def status: Option[zio.aws.gamelift.model.GameServerGroupStatus]
    def statusReason: Option[NonZeroAndMaxString]
    def suspendedActions
        : Option[List[zio.aws.gamelift.model.GameServerGroupAction]]
    def creationTime: Option[Timestamp]
    def lastUpdatedTime: Option[Timestamp]
    def getGameServerGroupName: ZIO[Any, AwsError, GameServerGroupName] =
      AwsError.unwrapOptionField("gameServerGroupName", gameServerGroupName)
    def getGameServerGroupArn: ZIO[Any, AwsError, GameServerGroupArn] =
      AwsError.unwrapOptionField("gameServerGroupArn", gameServerGroupArn)
    def getRoleArn: ZIO[Any, AwsError, IamRoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getInstanceDefinitions: ZIO[Any, AwsError, List[
      zio.aws.gamelift.model.InstanceDefinition.ReadOnly
    ]] = AwsError.unwrapOptionField("instanceDefinitions", instanceDefinitions)
    def getBalancingStrategy
        : ZIO[Any, AwsError, zio.aws.gamelift.model.BalancingStrategy] =
      AwsError.unwrapOptionField("balancingStrategy", balancingStrategy)
    def getGameServerProtectionPolicy: ZIO[
      Any,
      AwsError,
      zio.aws.gamelift.model.GameServerProtectionPolicy
    ] = AwsError.unwrapOptionField(
      "gameServerProtectionPolicy",
      gameServerProtectionPolicy
    )
    def getAutoScalingGroupArn: ZIO[Any, AwsError, AutoScalingGroupArn] =
      AwsError.unwrapOptionField("autoScalingGroupArn", autoScalingGroupArn)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.gamelift.model.GameServerGroupStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStatusReason: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("statusReason", statusReason)
    def getSuspendedActions: ZIO[Any, AwsError, List[
      zio.aws.gamelift.model.GameServerGroupAction
    ]] = AwsError.unwrapOptionField("suspendedActions", suspendedActions)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastUpdatedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedTime", lastUpdatedTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.GameServerGroup
  ) extends zio.aws.gamelift.model.GameServerGroup.ReadOnly {
    override val gameServerGroupName: Option[GameServerGroupName] = scala
      .Option(impl.gameServerGroupName())
      .map(value =>
        zio.aws.gamelift.model.primitives.GameServerGroupName(value)
      )
    override val gameServerGroupArn: Option[GameServerGroupArn] = scala
      .Option(impl.gameServerGroupArn())
      .map(value => zio.aws.gamelift.model.primitives.GameServerGroupArn(value))
    override val roleArn: Option[IamRoleArn] = scala
      .Option(impl.roleArn())
      .map(value => zio.aws.gamelift.model.primitives.IamRoleArn(value))
    override val instanceDefinitions
        : Option[List[zio.aws.gamelift.model.InstanceDefinition.ReadOnly]] =
      scala
        .Option(impl.instanceDefinitions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.gamelift.model.InstanceDefinition.wrap(item)
          }.toList
        )
    override val balancingStrategy
        : Option[zio.aws.gamelift.model.BalancingStrategy] = scala
      .Option(impl.balancingStrategy())
      .map(value => zio.aws.gamelift.model.BalancingStrategy.wrap(value))
    override val gameServerProtectionPolicy
        : Option[zio.aws.gamelift.model.GameServerProtectionPolicy] = scala
      .Option(impl.gameServerProtectionPolicy())
      .map(value =>
        zio.aws.gamelift.model.GameServerProtectionPolicy.wrap(value)
      )
    override val autoScalingGroupArn: Option[AutoScalingGroupArn] = scala
      .Option(impl.autoScalingGroupArn())
      .map(value =>
        zio.aws.gamelift.model.primitives.AutoScalingGroupArn(value)
      )
    override val status: Option[zio.aws.gamelift.model.GameServerGroupStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.gamelift.model.GameServerGroupStatus.wrap(value))
    override val statusReason: Option[NonZeroAndMaxString] = scala
      .Option(impl.statusReason())
      .map(value =>
        zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
      )
    override val suspendedActions
        : Option[List[zio.aws.gamelift.model.GameServerGroupAction]] = scala
      .Option(impl.suspendedActions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.gamelift.model.GameServerGroupAction.wrap(item)
        }.toList
      )
    override val creationTime: Option[Timestamp] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.gamelift.model.primitives.Timestamp(value))
    override val lastUpdatedTime: Option[Timestamp] = scala
      .Option(impl.lastUpdatedTime())
      .map(value => zio.aws.gamelift.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.GameServerGroup
  ): zio.aws.gamelift.model.GameServerGroup.ReadOnly = new Wrapper(impl)
}
