package zio.aws.gamelift.model
import scala.jdk.CollectionConverters._
sealed trait GameServerGroupAction {
  def unwrap
      : software.amazon.awssdk.services.gamelift.model.GameServerGroupAction
}
object GameServerGroupAction {
  def wrap(
      value: software.amazon.awssdk.services.gamelift.model.GameServerGroupAction
  ): zio.aws.gamelift.model.GameServerGroupAction = value match {
    case software.amazon.awssdk.services.gamelift.model.GameServerGroupAction.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.gamelift.model.GameServerGroupAction.REPLACE_INSTANCE_TYPES =>
      val r = REPLACE_INSTANCE_TYPES
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.gamelift.model.GameServerGroupAction {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.GameServerGroupAction =
      software.amazon.awssdk.services.gamelift.model.GameServerGroupAction.UNKNOWN_TO_SDK_VERSION
  }
  case object REPLACE_INSTANCE_TYPES
      extends zio.aws.gamelift.model.GameServerGroupAction {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.GameServerGroupAction =
      software.amazon.awssdk.services.gamelift.model.GameServerGroupAction.REPLACE_INSTANCE_TYPES
  }
}
