package zio.aws.gamelift.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.gamelift.model.primitives.PositiveInteger
import scala.jdk.CollectionConverters._
final case class GameServerGroupAutoScalingPolicy(
    estimatedInstanceWarmup: Option[PositiveInteger] = None,
    targetTrackingConfiguration: zio.aws.gamelift.model.TargetTrackingConfiguration
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.GameServerGroupAutoScalingPolicy = {
    import GameServerGroupAutoScalingPolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.GameServerGroupAutoScalingPolicy
      .builder()
      .optionallyWith(
        estimatedInstanceWarmup.map(value =>
          PositiveInteger.unwrap(value): Integer
        )
      )(_.estimatedInstanceWarmup)
      .targetTrackingConfiguration(targetTrackingConfiguration.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.gamelift.model.GameServerGroupAutoScalingPolicy.ReadOnly =
    zio.aws.gamelift.model.GameServerGroupAutoScalingPolicy
      .wrap(buildAwsValue())
}
object GameServerGroupAutoScalingPolicy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.GameServerGroupAutoScalingPolicy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.GameServerGroupAutoScalingPolicy =
      zio.aws.gamelift.model.GameServerGroupAutoScalingPolicy(
        estimatedInstanceWarmup.map(value => value),
        targetTrackingConfiguration.asEditable
      )
    def estimatedInstanceWarmup: Option[PositiveInteger]
    def targetTrackingConfiguration
        : zio.aws.gamelift.model.TargetTrackingConfiguration.ReadOnly
    def getEstimatedInstanceWarmup: ZIO[Any, AwsError, PositiveInteger] =
      AwsError.unwrapOptionField(
        "estimatedInstanceWarmup",
        estimatedInstanceWarmup
      )
    def getTargetTrackingConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.gamelift.model.TargetTrackingConfiguration.ReadOnly
    ] = ZIO.succeed(targetTrackingConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.GameServerGroupAutoScalingPolicy
  ) extends zio.aws.gamelift.model.GameServerGroupAutoScalingPolicy.ReadOnly {
    override val estimatedInstanceWarmup: Option[PositiveInteger] = scala
      .Option(impl.estimatedInstanceWarmup())
      .map(value => zio.aws.gamelift.model.primitives.PositiveInteger(value))
    override val targetTrackingConfiguration
        : zio.aws.gamelift.model.TargetTrackingConfiguration.ReadOnly =
      zio.aws.gamelift.model.TargetTrackingConfiguration
        .wrap(impl.targetTrackingConfiguration())
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.GameServerGroupAutoScalingPolicy
  ): zio.aws.gamelift.model.GameServerGroupAutoScalingPolicy.ReadOnly =
    new Wrapper(impl)
}
