package zio.aws.gamelift.model
import scala.jdk.CollectionConverters._
sealed trait GameServerHealthCheck {
  def unwrap
      : software.amazon.awssdk.services.gamelift.model.GameServerHealthCheck
}
object GameServerHealthCheck {
  def wrap(
      value: software.amazon.awssdk.services.gamelift.model.GameServerHealthCheck
  ): zio.aws.gamelift.model.GameServerHealthCheck = value match {
    case software.amazon.awssdk.services.gamelift.model.GameServerHealthCheck.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.gamelift.model.GameServerHealthCheck.HEALTHY =>
      val r = HEALTHY
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.gamelift.model.GameServerHealthCheck {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.GameServerHealthCheck =
      software.amazon.awssdk.services.gamelift.model.GameServerHealthCheck.UNKNOWN_TO_SDK_VERSION
  }
  case object HEALTHY extends zio.aws.gamelift.model.GameServerHealthCheck {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.GameServerHealthCheck =
      software.amazon.awssdk.services.gamelift.model.GameServerHealthCheck.HEALTHY
  }
}
