package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.gamelift.model.primitives.{
  GameServerInstanceId,
  GameServerGroupArn,
  GameServerGroupName
}
import scala.jdk.CollectionConverters._
final case class GameServerInstance(
    gameServerGroupName: Option[GameServerGroupName] = None,
    gameServerGroupArn: Option[GameServerGroupArn] = None,
    instanceId: Option[GameServerInstanceId] = None,
    instanceStatus: Option[zio.aws.gamelift.model.GameServerInstanceStatus] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.GameServerInstance = {
    import GameServerInstance.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.GameServerInstance
      .builder()
      .optionallyWith(
        gameServerGroupName.map(value =>
          GameServerGroupName.unwrap(value): java.lang.String
        )
      )(_.gameServerGroupName)
      .optionallyWith(
        gameServerGroupArn.map(value =>
          GameServerGroupArn.unwrap(value): java.lang.String
        )
      )(_.gameServerGroupArn)
      .optionallyWith(
        instanceId.map(value =>
          GameServerInstanceId.unwrap(value): java.lang.String
        )
      )(_.instanceId)
      .optionallyWith(instanceStatus.map(value => value.unwrap))(
        _.instanceStatus
      )
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.GameServerInstance.ReadOnly =
    zio.aws.gamelift.model.GameServerInstance.wrap(buildAwsValue())
}
object GameServerInstance {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.GameServerInstance
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.GameServerInstance =
      zio.aws.gamelift.model.GameServerInstance(
        gameServerGroupName.map(value => value),
        gameServerGroupArn.map(value => value),
        instanceId.map(value => value),
        instanceStatus.map(value => value)
      )
    def gameServerGroupName: Option[GameServerGroupName]
    def gameServerGroupArn: Option[GameServerGroupArn]
    def instanceId: Option[GameServerInstanceId]
    def instanceStatus: Option[zio.aws.gamelift.model.GameServerInstanceStatus]
    def getGameServerGroupName: ZIO[Any, AwsError, GameServerGroupName] =
      AwsError.unwrapOptionField("gameServerGroupName", gameServerGroupName)
    def getGameServerGroupArn: ZIO[Any, AwsError, GameServerGroupArn] =
      AwsError.unwrapOptionField("gameServerGroupArn", gameServerGroupArn)
    def getInstanceId: ZIO[Any, AwsError, GameServerInstanceId] =
      AwsError.unwrapOptionField("instanceId", instanceId)
    def getInstanceStatus
        : ZIO[Any, AwsError, zio.aws.gamelift.model.GameServerInstanceStatus] =
      AwsError.unwrapOptionField("instanceStatus", instanceStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.GameServerInstance
  ) extends zio.aws.gamelift.model.GameServerInstance.ReadOnly {
    override val gameServerGroupName: Option[GameServerGroupName] = scala
      .Option(impl.gameServerGroupName())
      .map(value =>
        zio.aws.gamelift.model.primitives.GameServerGroupName(value)
      )
    override val gameServerGroupArn: Option[GameServerGroupArn] = scala
      .Option(impl.gameServerGroupArn())
      .map(value => zio.aws.gamelift.model.primitives.GameServerGroupArn(value))
    override val instanceId: Option[GameServerInstanceId] = scala
      .Option(impl.instanceId())
      .map(value =>
        zio.aws.gamelift.model.primitives.GameServerInstanceId(value)
      )
    override val instanceStatus
        : Option[zio.aws.gamelift.model.GameServerInstanceStatus] = scala
      .Option(impl.instanceStatus())
      .map(value => zio.aws.gamelift.model.GameServerInstanceStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.GameServerInstance
  ): zio.aws.gamelift.model.GameServerInstance.ReadOnly = new Wrapper(impl)
}
