package zio.aws.gamelift.model
import scala.jdk.CollectionConverters._
sealed trait GameServerInstanceStatus {
  def unwrap
      : software.amazon.awssdk.services.gamelift.model.GameServerInstanceStatus
}
object GameServerInstanceStatus {
  def wrap(
      value: software.amazon.awssdk.services.gamelift.model.GameServerInstanceStatus
  ): zio.aws.gamelift.model.GameServerInstanceStatus = value match {
    case software.amazon.awssdk.services.gamelift.model.GameServerInstanceStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.gamelift.model.GameServerInstanceStatus.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.gamelift.model.GameServerInstanceStatus.DRAINING =>
      val r = DRAINING
      r
    case software.amazon.awssdk.services.gamelift.model.GameServerInstanceStatus.SPOT_TERMINATING =>
      val r = SPOT_TERMINATING
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.gamelift.model.GameServerInstanceStatus {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.GameServerInstanceStatus =
      software.amazon.awssdk.services.gamelift.model.GameServerInstanceStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ACTIVE extends zio.aws.gamelift.model.GameServerInstanceStatus {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.GameServerInstanceStatus =
      software.amazon.awssdk.services.gamelift.model.GameServerInstanceStatus.ACTIVE
  }
  case object DRAINING extends zio.aws.gamelift.model.GameServerInstanceStatus {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.GameServerInstanceStatus =
      software.amazon.awssdk.services.gamelift.model.GameServerInstanceStatus.DRAINING
  }
  case object SPOT_TERMINATING
      extends zio.aws.gamelift.model.GameServerInstanceStatus {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.GameServerInstanceStatus =
      software.amazon.awssdk.services.gamelift.model.GameServerInstanceStatus.SPOT_TERMINATING
  }
}
