package zio.aws.gamelift.model
import scala.jdk.CollectionConverters._
sealed trait GameServerUtilizationStatus {
  def unwrap: software.amazon.awssdk.services.gamelift.model.GameServerUtilizationStatus
}
object GameServerUtilizationStatus {
  def wrap(
      value: software.amazon.awssdk.services.gamelift.model.GameServerUtilizationStatus
  ): zio.aws.gamelift.model.GameServerUtilizationStatus = value match {
    case software.amazon.awssdk.services.gamelift.model.GameServerUtilizationStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.gamelift.model.GameServerUtilizationStatus.AVAILABLE =>
      val r = AVAILABLE
      r
    case software.amazon.awssdk.services.gamelift.model.GameServerUtilizationStatus.UTILIZED =>
      val r = UTILIZED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.gamelift.model.GameServerUtilizationStatus {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.GameServerUtilizationStatus =
      software.amazon.awssdk.services.gamelift.model.GameServerUtilizationStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object AVAILABLE
      extends zio.aws.gamelift.model.GameServerUtilizationStatus {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.GameServerUtilizationStatus =
      software.amazon.awssdk.services.gamelift.model.GameServerUtilizationStatus.AVAILABLE
  }
  case object UTILIZED
      extends zio.aws.gamelift.model.GameServerUtilizationStatus {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.GameServerUtilizationStatus =
      software.amazon.awssdk.services.gamelift.model.GameServerUtilizationStatus.UTILIZED
  }
}
